<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcCargo;
use App\Modules\Natureza51\Repositories\RepoLotacao;
use App\Modules\Natureza51\Repositories\RepoCargo;

use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;

class RepoOrcLotacaoCargoSal extends RepoOrcamento
{
    
    //protected $model_name_space_local='App\Modules\Natureza51\Entities\OrcCargosAreaSal';
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcCargosAreaSal';
    protected $form_rules=[];
    protected $rules_msg=[]; 
 
    function __construct() {
        //$this->setModelNameSpace('App\Modules\Natureza51\Entities\OrcCargosAreaSal');
        parent::__construct();
    }
    public function listAll($orc_id, $lotac_id = null){
        $repo_orc_lot = new RepoOrcLotacao();
        $tbl_orc_lot = $repo_orc_lot->getModelEntity();


        $repo_cargo = new RepoCargo();
        $tbl_cargo = $repo_cargo->getModelEntity();

        $repo_orc_cargo = new RepoOrcCargo();
        $tbl_orc_cargo = $repo_orc_cargo->getModelEntity();

        $repo_lot = new RepoLotacao();
        $tbl_lot =  $repo_lot->getModelEntity();

        $calc_orc_repo=$this->setCalOrcRepo()->getCalcOrcRepo();
        $tbl_calc_orc = $calc_orc_repo->getModelEntity();
        $calc_orc_table=$calc_orc_repo->getModelEntity()->getTable();
        
        $lotacao_carg_sal_table=$this->getModelEntity()->getTable();
        $query= $this->getModelEntity()
            ->leftJoin($tbl_orc_cargo->getTable(),
                $this->getModelEntity()->getColunaAlias('cargo_id'),'=',$tbl_orc_cargo->getColunaAlias('id'))

                ->leftJoin($tbl_cargo->getTable(),
                $tbl_orc_cargo->getColunaAlias('cargo_id'),'=',$tbl_cargo->getColunaAlias('id'))
            
                ->leftJoin($tbl_orc_lot->getTable(),
            $this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$tbl_orc_lot->getColunaAlias('id'))
            ->leftJoin($tbl_lot->getTable(),
                        $tbl_orc_lot->getColunaAlias('lotacao_id'),'=',
                        $tbl_lot->getColunaAlias("id"))
            ->leftJoin($calc_orc_table, 
            $this->getModelEntity()->getColunaAlias('id'), '=',
            DB::raw($calc_orc_repo->getModelEntity()->getColunaAlias('origem_id')." AND tbl_origem='".$lotacao_carg_sal_table."'")
            ) 
            ->select(
                $this->getModelEntity()->getColunaAlias('orcamento_id'),
                $this->getModelEntity()->getColunaAlias('cargo_id'),
                $this->getModelEntity()->getColunaAlias('lotacao_id'),
                $this->getModelEntity()->getColunaAlias('sal_base'),
                $this->getModelEntity()->getColunaAlias('sal_max'),
                $this->getModelEntity()->getColunaAlias('sal_med'),
                $this->getModelEntity()->getColunaAlias('sal_min'),
                $tbl_lot->getColunaAlias('des_unid_lotac'),
                $tbl_cargo->getColunaAlias('des_cargo_basic'),
                $tbl_calc_orc->getColunaAlias("id"),
                $tbl_calc_orc->getColunaAlias('origem_id'),
                $tbl_calc_orc->getColunaAlias('jan_orcado'),
                $tbl_calc_orc->getColunaAlias('fev_orcado'),
                $tbl_calc_orc->getColunaAlias('mar_orcado'),
                $tbl_calc_orc->getColunaAlias('abr_orcado'),
                $tbl_calc_orc->getColunaAlias('mai_orcado'),
                $tbl_calc_orc->getColunaAlias('jun_orcado'),
                $tbl_calc_orc->getColunaAlias('jul_orcado'),
                $tbl_calc_orc->getColunaAlias('ago_orcado'),
                $tbl_calc_orc->getColunaAlias('set_orcado'),
                $tbl_calc_orc->getColunaAlias('out_orcado'),
                $tbl_calc_orc->getColunaAlias('nov_orcado'),
                $tbl_calc_orc->getColunaAlias('dez_orcado')
            
            )
            ->where($this->getModelEntity()->getColunaAlias('orcamento_id'),'=', $orc_id);

        
        if(!is_null($lotac_id)){
            $query->where('lotacao_id', '=', $lotac_id);
        }
 
        return $query->get();
        
        $cargo_sal = $query->get()->toArray();
        
        if(!($orc = $cargo_sal->first())){
            //$this->setError(['Orçamento não encontrado.', 'Erro: 031220191636']);
            return $cargo_sal;
        }
        $orc_f=$orc->getOrcamento();
        
        if(!$orc_f){
             $this->setError(['Orçamento não encontrado.', 'Erro: 031220191803']);
            return false;
        }
        $atual=$orc_f->first();
        
        if(!$atual){
             $this->setError(['Orçamento não encontrado.', 'Erro: 031220191804']);
            return false;
        }
        
        if($this->setOrcamento($atual)->has()===false){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191635']);
            return false;
        }
        if($this->isOwn()===false){
            $this->setError(['Você não tem permissão para acessar estas informações.', 'Erro: 031220191637']);
            return false;
        }
        
        if(!$orc){
           $this->setError(['Informe um orçamento','Erro: 021220191834']);
           return false;
        }
        
        return $cargo_sal->count()==0 ? []: $cargo_sal;
       
    }

    public function createOrcLotCargo(array $dados, $call_back_success=null, $call_ball_error=null){
        
        
        $this->clearError();
       
        // $orc= $this->getModelEntity()->where('orcamento_id','=', $this->extractOrcamentoIdFromData($dados,'orcamento_id'))->first();
       
        // if(!$orc){
        //    $this->setError(['Informe um orçamento','Erro: 240220201703']);
        //    return false;
        // }
        
        if(isset($dados['meses_orcado'])==false){
            $this->setError('Preencha os meses');
            return false;
        }
        
    //    if($this->setOrcamento($orc->getOrcamento()->first())->canEdit()===false){
    //        $this->setError('O estado do orçamento não permite este tipo de operação.', 'Erro: 021220191837');
    //        return false;
    //    }
       $orc_sal_salario = $this->getModelEntity()->where([
           ['orcamento_id',$this->extractOrcamentoIdFromData($dados)],
           ['lotacao_id',$this->extractLotacaoIdFromData($dados,'lotacao_id')],
        //    ['ccusto_id',$dados['ccusto_id']],
           ['cargo_id',$dados['cargo_id']]
       ])->get()->toArray();
   
       if(!empty($orc_sal_salario)){
        $this->setError('Cargo já cadastrado.');
        return false;
       }

 
       
       DB::beginTransaction();

       $dados['empresa_id'] = 1;
       $dados['sal_maior'] = $dados['sal_max'];
       $dados['sal_menor'] = $dados['sal_min'];
       $dados['sal_med'] = ($dados['sal_max'] + $dados['sal_min'])/2;
    //    dd($dados);

       try{
            $salvou = $this->create($dados);
            if(!$salvou){
                return false;
            }

            $repo_calc_orc=new RepoCalcOrcamento();
            $salvou_calc= $repo_calc_orc->create(array_merge($dados['meses_orcado'],["origem_id"=>$salvou->id, "tbl_origem"=>$this->getModelEntity()->getTable()]));
            
            if($salvou_calc==false){
                $this->setError([$repo_calc_orc->getErrosFlatted(),'Erro: 021220191908']);
                DB::rollBack();
                return false;
            }

            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
       }
        return true;
        
    } 
    // public function updateOrc(array $data, $id, $attribute = "id", $call_back_success=null, $call_ball_error=null) {
    //     parent::update($data, $id, $attribute);
    // }
 
    public function updateOrc(array $data, $id, $attribute = "id") {
        $repo_calc_orc= new RepoCalcOrcamento();
        $meses_filter = $this->clearData($data);
        $data_filter = $this->clearMeses($data);
        //dd($data_filter);
        
        if($data_filter['sal_base']==null || $data_filter['sal_base']==""){
            $data_filter['sal_base']="0";
        }
        if($data_filter['sal_med']==null || $data_filter['sal_med']==""){
            $data_filter['sal_med']="0";
        }
        if($data_filter['sal_menor']==null || $data_filter['sal_menor']==""){
            $data_filter['sal_menor']="0";
        }
        if($data_filter['sal_maior']==null || $data_filter['sal_maior']==""){
            $data_filter['sal_maior']="0";
        }

        DB::beginTransaction();
        try {
            
            $data_filter['sal_base']=$this->formataSalario($data_filter['sal_base']);
            $data_filter['sal_med']=$this->formataSalario($data_filter['sal_med']);
            $data_filter['sal_menor']=$this->formataSalario($data_filter['sal_menor']);
            $data_filter['sal_maior']=$this->formataSalario($data_filter['sal_maior']);

            if(!$this->update($data_filter,$id)){
                
                return false;
            }  

            $meses=Arr::only($meses_filter,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado']);
            $meses=convertDecimalEn($meses);
            //$meses_filter=array_merge($meses_filter,$meses);
            
            if(!$repo_calc_orc->update($meses,$data['id'])){
                return false;
            }    
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
            return false;
        }
        return true;
    }

    public function deleteOrc(array $data, $id, $attribute = "id") {
        $repo_calc_orc= new RepoCalcOrcamento();
        // dd("delete", $data, $id);
        DB::beginTransaction();
        try {
            if(!$this->delete($id)){
                return false;
            }      
            if(!$repo_calc_orc->delete($data['id'])){
                return false;
            }    
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
            return false;
        }
        return true;
    }

    public function clearMeses($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','sal_max','sal_min','data_calc','origem_id','id'];
        return $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));          
    }
    public function clearData($data){
        $array_orcamento=['id','origem_id','sal_max','sal_min','data_calc','orcamento_id','cargo_id','lotacao_id','sal_base','sal_maior','sal_med','sal_menor','empresa_id','ccusto_id'];
        return $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));   
    }
    public function formataSalario($value){
        $value=str_replace('.','',$value);
        $value=str_replace(',','.',$value);
        return $value;
    }
    
    /**
     * 
     *   { field: 'lotacao', header: 'Cód. Lotação'},
            { field: 'cargo', header: 'Cargos'},
            { field: 'grupo_sal', header: 'Grupo sal.'},
            { field: 'sal_base', header: 'Sál base'},
            { field: 'salmed', header: 'Sál med'},
            { field: 'sal_meno', header: 'Sál menor'},
            { field: 'sal_maior', header: 'Sál maior'},
            { field: 'jan_ind', header: 'Jan' },
            { field: 'fev_ind', header: 'Fev' },
            { field: 'mar_ind', header: 'Mar' },
            { field: 'abr_ind', header: 'Abr' },
            { field: 'mai_ind', header: 'Mai' },
            { field: 'jun_ind', header: 'Jun' },
            { field: 'jul_ind', header: 'Jul' },
            { field: 'ago_ind', header: 'Ago' },
            { field: 'set_ind', header: 'Set' },
            { field: 'out_ind', header: 'Out' },
            { field: 'nov_ind', header: 'Nov' },
            { field: 'dez_ind', header: 'Dez' }, 
     * 
     * 
     * SELECT 
	*
FROM
	tbl_orcamento orc
INNER JOIN 
 tbl_orc_cargos_area_sal ocal ON orc.id=ocal.orcamento_id
LEFT JOIN
	tbl_calc_indice ci
ON ci.tbl_origem ='tbl_orc_cargos_area_sal' AND ci.origem_id=ocal.id 
WHERE
orc.id=5
     */
    
}
