<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcPremissas;
use Illuminate\Support\Facades\DB;

class RepoOrcPremissas extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcPremissas';
    public $form_rules=[
        'orcamento_id'     => 'required|exists:tbl_orcamento,id|unique:tbl_orc_premissas',
    ];
    protected $rules_msg=[
        'orcamento_id.required'    		=> 'O campo Orçamento é obrigatório!',
        'orcamento_id.exists'      		=> 'O campo Orçamento deve ter referencia na tabela de "Orçamentos"!',
        'orcamento_id.unique'      		=> 'Já existe um registro para esse orçamento!',
    ]; 

    public function getObservacoes($orcamento_id){
        $observacoes = OrcPremissas::where('orcamento_id', $orcamento_id)->first();
        return $observacoes;
    }

    
}
