<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;

use Illuminate\Support\Facades\DB;

class RepoOrcPromocao extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcPromocao';
    protected $form_rules=[
        'orc_id'=>'required',
        // 'lotacao_id'=>'required',
        'cargo_atual_id'=>'required',
        'cargo_promovido_id'=>'required',
        'funcionario_id'=>'required',
        // 'turma_atual_id'=>'required',
        'turma_promovida_id'=>'required',
        'ccusto_id'=>'required'
    ];
    protected $rules_msg=[
        'orc_id.required'=>'Selecione um orçamento para continuar!',
        'cargo_atual_id.required'=>'Selecione o cargo ancestral para continuar!',
        'cargo_promovido_id.required'=>'Selecione o cargo destino!',
        // 'turma_atual_id.required'=>'Selecione uma turma para continuar',
        'turma_promovida_id.required'=>'Selecione uma turma para continuar',
        'ccusto_id.required'=>'Selecione um centro de custo para continuar',
        'funcionario_id.required'=>'Selecione um funcionário!'
    ]; 

    public function __construct()
    {
        parent::__construct();
    }
    
    public function listar(){
        $tbl_orc_promo = new OrcPromocao();    
        $tbl_calc_orc = new CalcOrcamento();
        $tbl_orc_cargo = new OrcCargosAreaSal();
        $tbl_cargo = new Cargo();
        $tbl_func = new Funcionario();
 
        return $tbl_orc_promo->join(
            $tbl_calc_orc->getTable(),
            $tbl_orc_promo->getColunaAlias('id'),'=',
            DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
            {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_promo->getTable()}'"))
            
            ->leftJoin(
                $tbl_func->getTable(),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),'=',$tbl_func->getColunaAlias('id')
            )
            //
            ->select(
                $tbl_orc_promo->getColunaAlias('id'),
                $tbl_orc_promo->getColunaAlias('orc_id'),
                // $tbl_orc_promo->getColunaAlias('lotacao_ancestral_id'),
                // $tbl_orc_promo->getColunaAlias('lotacao_corrente_id'),
                $tbl_orc_promo->getColunaAlias('lotacao_id'),
                $tbl_orc_promo->getColunaAlias('cargo_atual_id'),
                $tbl_orc_promo->getColunaAlias('cargo_promovido_id'),
                DB::raw($tbl_orc_promo->getColunaAlias('cargo_promovido_id').'+null as des_cargo_basic'),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),
                $tbl_func->getColunaAlias('nome_funcionario'),
                // DB::raw($tbl_cargo->getColunaAlias('des_cargo_basic').' as des_cargo_basic_ancestral'),
                // 'c.des_cargo_basic as des_cargo_basic_corrente',
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jan_orcado')}, 'N', 'pt-br') AS jan_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('fev_orcado')}, 'N', 'pt-br') AS fev_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('mar_orcado')}, 'N', 'pt-br') AS mar_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('abr_orcado')}, 'N', 'pt-br') AS abr_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('mai_orcado')}, 'N', 'pt-br') AS mai_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jun_orcado')}, 'N', 'pt-br') AS jun_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jul_orcado')}, 'N', 'pt-br') AS jul_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('ago_orcado')}, 'N', 'pt-br') AS ago_orcado"), 
                DB::raw("format({$tbl_calc_orc->getColunaAlias('set_orcado')}, 'N', 'pt-br') AS set_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('out_orcado')}, 'N', 'pt-br') AS out_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('nov_orcado')}, 'N', 'pt-br') AS nov_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('dez_orcado')}, 'N', 'pt-br') AS dez_orcado")
            )->get()->toArray();


    } 
    public function listarByLotacao($orc_id, $lotacao_id, $tipo_table){
        $tbl_orc_promo = new OrcPromocao();    
        $tbl_calc_orc = new CalcOrcamento();
        $tbl_orc_cargo = new OrcCargosAreaSal();
        $tbl_cargo = new Cargo();
        $tbl_func = new Funcionario();

        $whereClause = [
            [$tbl_orc_promo->getColunaAlias('orc_id'),$orc_id],
            [$tbl_orc_promo->getColunaAlias('lotacao_id'),$lotacao_id],
            [$tbl_orc_promo->getColunaAlias('tipo_table'),$tipo_table]
        ];
 
        return $tbl_orc_promo->join(
            $tbl_calc_orc->getTable(),
            $tbl_orc_promo->getColunaAlias('id'),'=',
            DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
            {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_promo->getTable()}'"))
            
            ->leftJoin(
                $tbl_func->getTable(),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),'=',$tbl_func->getColunaAlias('id')
            )
            ->select(
                $tbl_orc_promo->getColunaAlias('id'),
                $tbl_orc_promo->getColunaAlias('orc_id'),
                // $tbl_orc_promo->getColunaAlias('lotacao_ancestral_id'),
                // $tbl_orc_promo->getColunaAlias('lotacao_corrente_id'),
                $tbl_orc_promo->getColunaAlias('lotacao_id'),
                $tbl_orc_promo->getColunaAlias('cargo_promovido_id'),
                $tbl_orc_promo->getColunaAlias('cargo_atual_id'),
                $tbl_orc_promo->getColunaAlias('turma_atual_id'),
                $tbl_orc_promo->getColunaAlias('turma_promovida_id'),
                $tbl_orc_promo->getColunaAlias('ccusto_id'),

                DB::raw($tbl_orc_promo->getColunaAlias('cargo_promovido_id').' as cargo_id'),
                $tbl_orc_promo->getColunaAlias('funcionario_id'),
                $tbl_func->getColunaAlias('nome_funcionario'),
                // DB::raw($tbl_cargo->getColunaAlias('des_cargo_basic').' as des_cargo_basic_ancestral'),
                // 'c.des_cargo_basic as des_cargo_basic_corrente',
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jan_orcado')}, 'N', 'pt-br') AS jan_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('fev_orcado')}, 'N', 'pt-br') AS fev_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('mar_orcado')}, 'N', 'pt-br') AS mar_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('abr_orcado')}, 'N', 'pt-br') AS abr_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('mai_orcado')}, 'N', 'pt-br') AS mai_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jun_orcado')}, 'N', 'pt-br') AS jun_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('jul_orcado')}, 'N', 'pt-br') AS jul_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('ago_orcado')}, 'N', 'pt-br') AS ago_orcado"), 
                DB::raw("format({$tbl_calc_orc->getColunaAlias('set_orcado')}, 'N', 'pt-br') AS set_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('out_orcado')}, 'N', 'pt-br') AS out_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('nov_orcado')}, 'N', 'pt-br') AS nov_orcado"),
                DB::raw("format({$tbl_calc_orc->getColunaAlias('dez_orcado')}, 'N', 'pt-br') AS dez_orcado")
            )
            ->where($whereClause)
            ->get()
            ->toArray();
                // dd("Promoções", $data);
                // return 
    }

    public function insertPromocao($data,$meses){    
            
        $clausule = array(
            'orc_id'=>$data['orc_id'],
            'lotacao_id'=>$data['lotacao_id'],
            'funcionario_id'=>$data['funcionario_id'],
            'turma_atual_id'=>$data['turma_atual_id'],
            'cargo_atual_id'=>$data['cargo_atual_id']
            // 'tipo_table'=>$data['tipo_table']
        );
        // dd("promooo",$clausule);
        if($this->hasDataOnDB($clausule)){
            $retorno['status']='error';
            $retorno['msg']='Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
        }
        $data = $this->putCargoIdOnData($data,$data['cargo_promovido_id']);
        $data = $this->putTurmaIdOnData($data,$data['turma_promovida_id']);
        
         DB::beginTransaction();
         $repo_calc_orcamento = new RepoCalcOrcamento();
 
         try {
            $id_orc_promocao = $this->checkHeadcount($data);
            // dd("orc", $id_orc_promocao); 
            if(!$id_orc_promocao){
                $retorno['status']="error";
                $retorno['msg']=$this->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 130120201242';
                // dd("volta", $retorno);
                goto saida;
            }    
            $merge_tb_calc = [
                'origem_id' => $id_orc_promocao->id,
                'tbl_origem' => $this->getModelEntity()->getTable()
            ];
            if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses))){
                
                $retorno['status']="error";
                $retorno['msg']='Falha ao inserir o registro. Erro: 130120201243';
                $retorno['submsg']=$repo_calc_orcamento->getErrosFlatted();
                goto saida;
            }
            $retorno['status']="success";
            $retorno['msg']="Cadastro realizado com sucesso!";
            goto saida;

         } catch (\Exception $e) {            
            DB::rollBack();
            abort(500,'Falha ao inserir registro. Erro: 130120201244.'.$e);
         }

         saida:

         ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
         return $retorno;
    }
    public function deletePromocao($id){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        DB::beginTransaction();
         try {
            if(!$repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$id,'tbl_origem'=>'tbl_orc_promocao'])->delete()){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
                goto saida;               
            } 

            if(!$this->delete($id)){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
                goto saida;               
            }
        
            $retorno["status"]="success";
            $retorno["msg"]="Registro deletado com sucesso!";
            goto saida;      
      
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao deletar registro no orçamento. Erro: 021220181942.'.$e);
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno;
         
    }
}
