<?php

namespace App\Modules\Natureza51\Repositories;

use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto as LotacaoCCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Empresa;
use App\Modules\Natureza51\Entities\ContaContabilVSEventos;
use App\Modules\Natureza51\Entities\ContaContabil; 
use App\Modules\Natureza51\Entities\Orcamento;
use \App\Core\Traits\ErrorTrait;

use Illuminate\Support\Facades\DB;

class RepoOrcScriptCalculos extends RepoOrcamento
{

    
    public function createCalcCargoArea($orc_id){
        $orc_cargo_area_sal = new OrcCargosAreaSal();
        $funcionario = new Funcionario();
        $orc_cargo = new OrcCargo();
        $cargo = new Cargo();
        $orc_lotacao = new OrcLotacao();
        $lotacao_c_custo = new LotacaoCCusto();
        $lotacao = new Lotacao();
        $centro_custo = new CentroCusto();
        $orc_eventos = new OrcEventos();
        $eventos = new Eventos();
        $empresa = new Empresa();
        $conta_contabil_vs_eventos = new ContaContabilVSEventos();
        $conta_contabil = new ContaContabil();
        $calc_orcamento = new CalcOrcamento();
        
        $entities = [
            'orcCargosAreaSal' => ['instance'=>$orc_cargo_area_sal],
            'funcionario' => ['instance'=>$funcionario],
            'orcCargo' => ['instance'=>$orc_cargo],
            'cargo' => ['instance' => $cargo],
            'orcLotacao' => ['instance' => $orc_lotacao],
            'lotacaoCCusto' => ['instance' => $lotacao_c_custo],
            'lotacao' => ['instance' => $lotacao],
            'centroCusto' => ['instance' => $centro_custo],
            'orcEventos' => ['instance' => $orc_eventos],
            'eventos' => ['instance' => $eventos],
            'empresa' => ['instance' => $empresa],
            'contaContabilVSEventos' => ['instance' => $conta_contabil_vs_eventos],
            'contaContabil' => ['instance' => $conta_contabil],
            'calcOrcamento' => ['instance' => $calc_orcamento]
        ];
        
        // $result = $this->insertUpcalcOrcLotacao($entities, $orc_id); 
        $result = $this->scriptMergeOrcLotacao($orc_id, 1);
        
        if($result["status"]!="success"){  
            return $result; 
        } 

        $calc_orc_cargo = $this->insertUpcalcOrcCargo($entities, $orc_id);
        
        if($calc_orc_cargo["status"]!="success"){
            return $calc_orc_cargo; 
        }

        $calc_orc_cargo_sal = $this->insertUpcalcOrcCargoAreaSal($entities, $orc_id);
        
        if($calc_orc_cargo_sal["status"]=="success"){
            $result = $this->insertCalcOrcamentoCargoAreaSal($entities, $orc_id);
        }

        if($calc_orc_cargo["status"]=="success"){
            $result = $this->insertCalcOrcamentoCargo($entities, $orc_id);
        }

        $calc_eventos = $this->insertUpcalcOrcEventos($entities, $orc_id);         
        
        if($calc_eventos["status"]=="success"){
            $result = $this->insertCalcOrcamentoEventos($orc_id);
        }
        $result = $this->scriptInsertOrcHeadCount($orc_id);
        
        $result = $this->scriptInsertHoraExtra($orc_id, 1);
        
        return $result;       
    }

    public function insertUpcalcOrcCargoAreaSal($entities, $orc_id){

        $tb_alias_a = $this->getTableAlias('a',$entities['funcionario']['instance'])['table'];         
        $tb_alias_b = $this->getTableAlias('b',$entities['orcCargo']['instance'])['table'];
        $tb_alias_c = $this->getTableAlias('c',$entities['orcLotacao']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['funcionario']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b',$entities['orcCargo']['instance'])['alias'];
        $alias_table_c = $this->getTableAlias('c',$entities['orcLotacao']['instance'])['alias'];
        
        $colunas = "
                    {$orc_id} orcamento_id, 
                    {$alias_table_b}.id cargo_id, 
                    {$alias_table_c}.id lotacao_id, 
                    null parametros_formula, 
                    avg(salario) sal_base, 
                    max(salario) sal_maior, 
                    avg(salario) sal_med, 
                    min(salario) sal_menor, 
                    {$alias_table_a}.empresa_id, 
                    {$alias_table_a}.ccusto_id
        ";

        $tipo_join = " INNER JOIN ";

        $on_a = " ON {$alias_table_a}.cargo_id = {$alias_table_b}.cargo_id AND {$alias_table_b}.orcamento_id = $orc_id ";

        $on_b = " ON {$alias_table_a}.lotacao_id = {$alias_table_c}.lotacao_id 
        AND {$alias_table_a}.ccusto_id = {$alias_table_c}.cc_custo_id AND {$alias_table_c}.orcamento_id = $orc_id ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a . $tipo_join . $tb_alias_c . $on_b;

        $where = " where {$alias_table_a}.dat_demis_func is null ";

        $group_by = " GROUP BY 
                        {$alias_table_b}.id,
                        {$alias_table_c}.id,
                        {$alias_table_a}.empresa_id,
                        {$alias_table_a}.ccusto_id 
                    ";
        
        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'group_by' => $group_by
        ];
        
        $select = $this->scriptSelectInsert($param_select_insert);
        
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcCargosAreaSal']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'cargo_id'
            ,'lotacao_id'
            ,'ccusto_id'
        ];

        $array_campos_update = [
            'sal_base'
            ,'sal_maior'
            ,'sal_med'
            ,'sal_menor'
            ,'updated_at'
        ];

        $array_colunas_insert = [
            'orcamento_id'
			,'cargo_id'
			,'lotacao_id'
			,'parametros_formula'
			,'sal_base'
			,'sal_maior'
			,'sal_med'
			,'sal_menor'
			,'empresa_id'
			,'ccusto_id'
			,'created_at'
            ,'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
        
        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result); 
        return $result;
    } 

    public function insertUpcalcOrcEventos($entities, $orc_id){

        $tb_alias_a = $this->getTableAlias('a',$entities['eventos']['instance'])['table'];         
        $tb_alias_b = $this->getTableAlias('b',$entities['empresa']['instance'])['table'];
        $tb_alias_c = $this->getTableAlias('c',$entities['contaContabilVSEventos']['instance'])['table'];         
        $tb_alias_d = $this->getTableAlias('d',$entities['contaContabil']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['eventos']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b',$entities['empresa']['instance'])['alias'];
        $alias_table_c = $this->getTableAlias('c',$entities['contaContabilVSEventos']['instance'])['alias'];
        $alias_table_d = $this->getTableAlias('d',$entities['contaContabil']['instance'])['alias'];
        
        $colunas = "
                    {$alias_table_a}.empresa_id,
                    {$orc_id} orcamento_id, 
                    {$alias_table_a}.id  evento_id,
                    {$alias_table_a}.cdn_event,
                    {$alias_table_a}.des_event,
                    {$alias_table_a}.inc_liquido,
                    {$alias_table_a}.impr_envel,
                    {$alias_table_a}.multiplica,
                    {$alias_table_a}.formula,
                    {$alias_table_a}.ativo,
                    {$alias_table_a}.origem,
                    {$alias_table_a}.tipo_evento_id

                    
        ";

        $tipo_join = " INNER JOIN ";

        $on_a = " ON {$alias_table_a}.empresa_id = {$alias_table_b}.id ";

        $on_b = " ON {$alias_table_c}.empresa_id = {$alias_table_b}.id AND {$alias_table_c}.eventos_id = {$alias_table_a}.id ";

        $on_c = " ON {$alias_table_d}.empresa_id = {$alias_table_b}.id AND {$alias_table_d}.id = {$alias_table_c}.cta_contabil_id ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a . 
                $tipo_join . $tb_alias_c . $on_b .
                $tipo_join . $tb_alias_d . $on_c;

        $where = " where {$alias_table_a}.ativo = 1 ";

        $group_by = " GROUP BY 
                        {$alias_table_a}.empresa_id,
                        {$alias_table_a}.id,
                        {$alias_table_a}.cdn_event,
                        {$alias_table_a}.des_event,
                        {$alias_table_a}.inc_liquido,
                        {$alias_table_a}.impr_envel,
                        {$alias_table_a}.multiplica,
                        {$alias_table_a}.formula,
                        {$alias_table_a}.ativo,
                        {$alias_table_a}.origem,
                        {$alias_table_a}.tipo_evento_id
      
                    ";
        
        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => $where,
            'group_by' => $group_by
        ];
        
        $select = $this->scriptSelectInsert($param_select_insert);
        // dd("adasdfasdf--->>>",$select);
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcEventos']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'evento_id'
        ];

        $array_campos_update = [
            'evento_id'
            ,'cdn_event'
            ,'des_event'
            ,'inc_liquido'
            ,'impr_envel'
            ,'multiplica'
            ,'formula'
            ,'ativo'
            ,'origem'
            ,'tipo_evento_id'
            ,'updated_at'
        ];

        $array_colunas_insert = [
            'empresa_id'
            ,'orcamento_id'
            ,'evento_id'
            ,'cdn_event'
            ,'des_event'
            ,'inc_liquido'
            ,'impr_envel'
            ,'multiplica'
            ,'formula'
            ,'ativo'
            ,'origem'
            ,'tipo_evento_id'
			,'created_at'
            ,'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
        
        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result); 
        return $result;
    }

    public function insertUpcalcOrcCargo($entities, $orc_id){

        $tb_alias_a = $this->getTableAlias('a',$entities['cargo']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['cargo']['instance'])['alias'];
        
        $colunas = "
                    {$orc_id} orcamento_id, 
                    {$alias_table_a}.id cargo_id, 
                    salario sal_base, 
                    salario_max sal_max, 
                    salario_min sal_min,
                    data_salario data_calc, 
                    null grupo_salarial
        ";

        $from = $tb_alias_a;
        
        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from
        ];
        
        $select = $this->scriptSelectInsert($param_select_insert);
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcCargo']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'cargo_id'
        ];

        $array_campos_update = [
            'sal_base'
            ,'sal_max'
            ,'sal_min'
            ,'data_calc'
            ,'updated_at'
        ];

        $array_colunas_insert = [
            'cargo_id', 
            'orcamento_id', 
            'sal_base', 
            'sal_max',
            'sal_min', 
            'data_calc', 
            'grupo_salarial',
			'created_at',
            'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
        
        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result); 
        return $result;
    }

    public function insertUpcalcOrcLotacao($entities, $orc_id){

        $lotacao_c_custo = new LotacaoCCusto();
        $lotacao = new Lotacao();
        $centro_custo = new CentroCusto();

        $tb_alias_a = $this->getTableAlias('a',$entities['lotacaoCCusto']['instance'])['table'];
        $tb_alias_b = $this->getTableAlias('b',$entities['lotacao']['instance'])['table'];
        $tb_alias_c = $this->getTableAlias('c',$entities['centroCusto']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a',$entities['lotacaoCCusto']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b',$entities['lotacao']['instance'])['alias'];
        $alias_table_c = $this->getTableAlias('c',$entities['centroCusto']['instance'])['alias'];
               
        $colunas = "
                    {$orc_id} orcamento_id, 
                    {$alias_table_b}.id lotacao_id, 
                    1 responder_orc, 
                    {$alias_table_c}.id cc_custo_id
        ";

        $tipo_join = " INNER JOIN ";

        $on_a = " ON {$alias_table_a}.lotacao_id = {$alias_table_b}.id AND 
                        {$alias_table_a}.empresa_id = {$alias_table_b}.empresa_id ";

        $on_b = " ON {$alias_table_a}.ccusto_id = {$alias_table_c}.id AND 
                        {$alias_table_c}.ativo = 1 AND {$alias_table_a}.empresa_id = {$alias_table_c}.empresa_id ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a 
                .$tipo_join . $tb_alias_c . $on_b;
        
        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from
        ];
        
        $select = $this->scriptSelectInsert($param_select_insert);
       
        // $campos_remover = array("id", "created_at", "updated_at");

        // $col_entitie_insert = $this->colEntitie($entities['orcCargosAreaSal']['instance'], $campos_remover);

        $table_entitie = $entities['orcLotacao']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'orcamento_id'
            ,'lotacao_id'
            ,'cc_custo_id'
        ];

        $array_campos_update = [
            'responder_orc'
            ,'cc_custo_id'
        ];

        $array_colunas_insert = [
            'orcamento_id'
            ,'lotacao_id'
            ,'responder_orc'
            ,'cc_custo_id'
			,'created_at'
            ,'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
        
        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result); 
        return $result;
    }

    public function scriptInsert($table_entitie, $select, $colunas, $orc_id){        
        // sequencia das colunas devem seguir a sequencia da select.
        $table = $table_entitie->getTable();
        
        $insert = DB::raw("
                INSERT INTO $table (                   
                    $colunas
                    , created_at
                    , updated_at
                    ) 
            " . $select);
                    
        DB::beginTransaction();

        try {

            $result = DB::connection()->insert(
                $insert , [$orc_id]
            );

            if(!$result){
                $retorno["status"]="error";
                $retorno['msg'] = $table_entitie->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer inserir registro. Erro: 30012021510';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir registro. Erro: 30012021515.'.$e);   
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno;   
    }
    
    public function scriptSelectInsert($param_select_insert){
        // sequencia das colunas devem seguir a sequencia do insert.
        $colunas = '';
        $from = '';
        $where = '';
        $group_by = '';
        $order_by = '';

        if(isset($param_select_insert['colunas']) && !is_null($param_select_insert['colunas'])){
            $colunas = $param_select_insert['colunas'];            
        }
        if(isset($param_select_insert['from']) && !is_null($param_select_insert['from'])){
            $from = $param_select_insert['from'];            
        }
        if(isset($param_select_insert['where']) && !is_null($param_select_insert['where'])){
            $where = $param_select_insert['where'];            
        }
        if(isset($param_select_insert['group_by']) && !is_null($param_select_insert['group_by'])){
            $group_by = $param_select_insert['group_by'];            
        }
        if(isset($param_select_insert['order_by']) && !is_null($param_select_insert['order_by'])){
            $order_by = $param_select_insert['order_by'];            
        }
        
        $select = "select 
                        {$colunas}
                        , getDate() created_at
                        , NULL updated_at  
                    FROM                       
                    {$from}
                    {$where}
                    {$group_by}
                    {$order_by}
            ";
            
        return $select;
    }

    public function scriptMergeInsertUpdate($table_entitie, $select, $array_merge){
        $table = $table_entitie->getTable();
        
        $array_on_colunas_chave_ex_primaria = '';
        $array_campos_update = '';
        $array_colunas_insert = '';
        $array_value_insert = '';
        
        for($i = 0; $i < count($array_merge['array_on_colunas_chave_ex_primaria']); $i++){
            ($i==0) ? $array_on_colunas_chave_ex_primaria .= " target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} " :
                      $array_on_colunas_chave_ex_primaria .= " AND target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                 source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} ";
        }
        
        for($i = 0; $i < count($array_merge['array_campos_update']); $i++){
            $up = '';
            ($array_merge['array_campos_update'][$i]=='updated_at') ? $up = "getDate()" : $up = "source.{$array_merge['array_campos_update'][$i]}";
            ($i==0) ? $array_campos_update .= " target.{$array_merge['array_campos_update'][$i]}=
                                                source.{$array_merge['array_campos_update'][$i]} " :
                      $array_campos_update .= " , target.{$array_merge['array_campos_update'][$i]}=
                                                    {$up} ";
        }
        
        for($i = 0; $i < count($array_merge['array_colunas_insert']); $i++){
            ($i==0) ? $array_colunas_insert .= " {$array_merge['array_colunas_insert'][$i]} " :
                      $array_colunas_insert .= ", {$array_merge['array_colunas_insert'][$i]} ";

            ($i==0) ? $array_value_insert .= " source.{$array_merge['array_colunas_insert'][$i]} " :
                      $array_value_insert .= ", source.{$array_merge['array_colunas_insert'][$i]} ";
        }
        
        $merge = "
        MERGE {$table} as target
                USING
                (
                    {$select}
                ) AS source
                ON
                    {$array_on_colunas_chave_ex_primaria}
                WHEN MATCHED 
                    THEN UPDATE SET
                        {$array_campos_update}
                WHEN NOT MATCHED BY target
                    THEN
                        INSERT (
                            {$array_colunas_insert}
                            )values(
                            {$array_value_insert}
                            )
            ;
        ";
        
        DB::beginTransaction();

        try {
              
            $pdo = DB::connection()->getPdo();
           
            $query = $pdo->prepare($merge);
            // dd('merge', $query);
            if ($query->execute()) { 
                $count = $query->rowCount();
            }               
            
            if(!$query){
                $retorno["status"]="error";
                $retorno['msg'] = implode(",", $query->errorInfo());
                $retorno['submsg']='Falha ao atualizar registro. Erro: 310120201126';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="{$count} Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 310120201122';
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 310120201123 - ' .implode(",", $query->errorInfo());            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd('retorno', $retorno);
        return $retorno; 
        
    }

    public function insertCalcOrcamentoCargo($entitie, $orc_id){

        $tb_alias_a = $this->getTableAlias('a', $entitie['orcCargo']['instance'])['table'];   
        $tb_alias_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a', $entitie['orcCargo']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['alias'];

        $colunas = "
                    {$alias_table_a}.id origem_id
                    ,'tbl_orc_cargo' [tbl_origem]
                    ,{$alias_table_a}.sal_base [jan_orcado]
                    ,{$alias_table_a}.sal_base [fev_orcado]
                    ,{$alias_table_a}.sal_base [mar_orcado]
                    ,{$alias_table_a}.sal_base [abr_orcado]
                    ,{$alias_table_a}.sal_base [mai_orcado]
                    ,{$alias_table_a}.sal_base [jun_orcado]
                    ,{$alias_table_a}.sal_base [jul_orcado]
                    ,{$alias_table_a}.sal_base [ago_orcado]
                    ,{$alias_table_a}.sal_base [set_orcado]
                    ,{$alias_table_a}.sal_base [out_orcado]
                    ,{$alias_table_a}.sal_base [nov_orcado]
                    ,{$alias_table_a}.sal_base [dez_orcado]      
                    ,NULL [user_id]      
                    ,{$alias_table_a}.[empresa_id]
                    
        ";

        $tipo_join = " LEFT JOIN ";

        $on_a = " ON {$alias_table_a}.id = {$alias_table_b}.origem_id AND 'tbl_orc_cargo' = {$alias_table_b}.tbl_origem ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a ;

        $where = " where {$alias_table_a}.orcamento_id = $orc_id AND {$alias_table_b}.id is null";
        
        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => $where
        ];
        
        $select = $this->scriptSelectInsert($param_select_insert);
       
        $table_entitie = $entitie['calcOrcamento']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'origem_id'
            ,'tbl_origem'
        ];

        $array_campos_update = [
            'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
        ];

        $array_colunas_insert = [
            'origem_id'
            ,'tbl_origem'
            ,'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
            ,'user_id'
            ,'empresa_id'
            ,'created_at'
            ,'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
        
        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result); 

        return $result;
    }

    public function insertCalcOrcamentoCargoAreaSal($entitie, $orc_id){

        $tb_alias_a = $this->getTableAlias('a', $entitie['orcCargosAreaSal']['instance'])['table'];   
        $tb_alias_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['table'];

        $alias_table_a = $this->getTableAlias('a', $entitie['orcCargosAreaSal']['instance'])['alias'];
        $alias_table_b = $this->getTableAlias('b', $entitie['calcOrcamento']['instance'])['alias'];

        $colunas = "
                    {$alias_table_a}.id origem_id
                    ,'tbl_orc_cargos_area_sal' [tbl_origem]
                    ,{$alias_table_a}.sal_base [jan_orcado]
                    ,{$alias_table_a}.sal_base [fev_orcado]
                    ,{$alias_table_a}.sal_base [mar_orcado]
                    ,{$alias_table_a}.sal_base [abr_orcado]
                    ,{$alias_table_a}.sal_base [mai_orcado]
                    ,{$alias_table_a}.sal_base [jun_orcado]
                    ,{$alias_table_a}.sal_base [jul_orcado]
                    ,{$alias_table_a}.sal_base [ago_orcado]
                    ,{$alias_table_a}.sal_base [set_orcado]
                    ,{$alias_table_a}.sal_base [out_orcado]
                    ,{$alias_table_a}.sal_base [nov_orcado]
                    ,{$alias_table_a}.sal_base [dez_orcado]      
                    ,NULL [user_id]      
                    ,{$alias_table_a}.[empresa_id]
                    
        ";

        $tipo_join = " LEFT JOIN ";

        $on_a = " ON {$alias_table_a}.id = {$alias_table_b}.origem_id AND 'tbl_orc_cargos_area_sal' = {$alias_table_b}.tbl_origem ";

        $from = $tb_alias_a . $tipo_join . $tb_alias_b . $on_a ;

        $where = " where {$alias_table_a}.orcamento_id = $orc_id AND {$alias_table_b}.id is null";
        
        $param_select_insert = [
            'colunas' => $colunas,
            'from' => $from,
            'where' => $where
        ];
        
        $select = $this->scriptSelectInsert($param_select_insert);
       
        $table_entitie = $entitie['calcOrcamento']['instance'];

        $array_on_colunas_chave_ex_primaria = [
            'origem_id'
            ,'tbl_origem'
        ];

        $array_campos_update = [
            'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
        ];

        $array_colunas_insert = [
            'origem_id'
            ,'tbl_origem'
            ,'jan_orcado'
            ,'fev_orcado'
            ,'mar_orcado'
            ,'abr_orcado'
            ,'mai_orcado'
            ,'jun_orcado'
            ,'jul_orcado'
            ,'ago_orcado'
            ,'set_orcado'
            ,'out_orcado'
            ,'nov_orcado'
            ,'dez_orcado'
            ,'user_id'
            ,'empresa_id'
            ,'created_at'
            ,'updated_at'
        ];

        $array_merge = [
            "array_on_colunas_chave_ex_primaria" => $array_on_colunas_chave_ex_primaria,
            "array_campos_update" =>$array_campos_update,
            "array_colunas_insert" => $array_colunas_insert
        ];
        
        // $result = $this->scriptInsert($table_entitie, $select, $col_entitie_insert, $orc_id);
        $result = $this->scriptMergeInsertUpdate($table_entitie, $select, $array_merge);
        // dd("insert_orc------>>>>", $result); 

        return $result;
    }

    public function scriptMergeOrcLotacao($orc_id, $responder_orc){
        $value  = 'Falha ao inserir Orçamento! Erro: 210220201518';
        
        DB::beginTransaction();

        try {                   
           
            $sql="EXEC insert_merge_lotacao :orc_id, :responder_orc";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':responder_orc', $responder_orc, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 210220201520 | insert_merge_lotacao';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $this->deleteOrcamento($orc_id);
            
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 210220201515 - ' . 'insert_merge_lotacao';            
        }
        
        saida:
        
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        return $retorno;    
    }

    public function scriptInsertOrcHeadCount($orc_id){
        $value  = 'Falha ao inserir registros na tela Headcount! Erro: 22022021330';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC popula_orc_headcount :orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 22022021330 | popula_orc_headcount';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 22022021318 - ' . 'popula_orc_headcount';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }
    
    public function scriptInsertHoraExtra($orc_id, $user){
        $value  = 'Falha ao inserir registros na tela Headcount Hora Extra! Erro: 280220201100';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC insert_hora_extra :orc_id, :user";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':user', $user, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 280220201100 | insert_hora_extra';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 280220201057 - ' . 'insert_hora_extra';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        return $retorno;    
    }

    public function insertCalcOrcamentoEventos($orc_id){
        $value  = 'Falha ao inserir registros na tela Controle Eventos! Erro: 060320201620';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC insert_calc_orcamento_x_orc_eventos :orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 060320201620 | insert_calc_orcamento_x_orc_eventos';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 060320201620 - ' . 'insert_calc_orcamento_x_orc_eventos';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        return $retorno;    
    }

    public function getTableAlias($alias, $entitie){
        $alias_table = $entitie->getTable().'_'.$alias;
        $tb_alias = $entitie->getTable();       
        $tb_alias = $tb_alias . " AS {$alias_table}";

        $result = [
            'alias' => $alias_table,
            'table' => $tb_alias
        ];
        return $result;
    }   

    public function colEntitie($entitie, $campos_remover){
        $result = implode(',', array_diff($entitie->getNomeColunas(), $campos_remover));

        return $result;
    }

    public function colEntitieSelectDiff($entitie, $campos_remover){
        $result = array_diff($entitie->getNomeColunas(), $campos_remover);

        return $result;
    }

    public function deleteOrcamento($orc_id){        
        $Orcamento = new Orcamento();

        DB::beginTransaction();
       
        try{
            
            if(!$Orcamento->deleteParent($data['id'])){  
                $this->setError('Falha ao deletar o Orçamento. Erro: 030320201105 ' .$this.getErrosFlatted());
                DB::rollBack();
                return false;                                  
            }
            
            DB::commit();
                
            } catch (Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao deletar o Orçamento. Erro: 080120201624.');
        }
        
        return array('msg'=>"Orçamento deletado!",'status'=>"success");
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

}
