<?php

namespace App\Modules\Natureza51\Repositories;

use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Empresa;
use App\Modules\Natureza51\Entities\ContaContabilVSEventos;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;

use \App\Core\Traits\ErrorTrait;

use Illuminate\Support\Facades\DB;

class RepoOrcScriptCloneOrc extends RepoOrcamento
{
    
    public function createCloneOrc($orcamento, $orc_id){
                
        $orcamento_param = [
            'ano' => $orcamento['ano'],
            'descricao' => $orcamento['descricao_orc'],
            'versao' => $orcamento['versao'],
            'revisao' => $orcamento['revisao']
        ];

        $data_procedure = $this->scriptProcedureInsertOrcamento($orc_id, $orcamento_param);
        
        if($data_procedure['status'] == "error"){
            return $data_procedure;
        }
               
        $clone_orc_id = $data_procedure['clone_orc_id'];

        $data_lotacao = $this->scriptInsertLotacao($orc_id, $clone_orc_id);

        if($data_lotacao['status'] == "error"){
            return $data_lotacao;
        }

        $this->clearError();

        $result[] = $this->scriptInsertCargo($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertCargosAreaSalario($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertSalarioFuncionario($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertHeadcount($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertEventos($orc_id, $clone_orc_id); 
        $result[] = $this->scriptInsertCloneHoraExtra($orc_id, $clone_orc_id, 1);  
        // $result[] = $this->scriptInsertHoraExtraEvento($orc_id, $clone_orc_id);          
        $result[] = $this->scriptInsertHeadcountHoraExtra($orc_id, $clone_orc_id);       
        $result[] = $this->scriptInsertAcordoColetivo($orc_id, $clone_orc_id);   
        $result[] = $this->scriptInsertBonus($orc_id, $clone_orc_id);   
        $result[] = $this->scriptInsertBeneficioLotCargo($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertBeneficio($orc_id, $clone_orc_id);        
        $result[] = $this->scriptInsertContratacoes($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertDemissoes($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertDespesas($orc_id, $clone_orc_id);             
        $result[] = $this->scriptInsertPremissas($orc_id, $clone_orc_id);        
        $result[] = $this->scriptInsertFerias($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertPromocao($orc_id, $clone_orc_id);
        $result[] = $this->scriptInsertBeneficioLotFuncionario($orc_id, $clone_orc_id);

        if($this->hasError()){
            return $result;
        }

        $retorno["status"]="success";
        $retorno["msg"]="Cadastrado com sucesso!";
        $retorno['submsg']="Registro cadastrado com sucesso!";
        return $retorno;       
    }

    public function scriptInsertCargo($orc_id, $clone_orc_id){
        $value  = 'Falha ao inserir registros na tela Aumentos Salariais! Erro: 030320201442';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_cargo :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 11022021812 | clone_orcamento_cargo';

                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 11022021809 - ' . 'clone_orcamento_cargo';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertBeneficioLotCargo($orc_id, $clone_orc_id){
        $value  = 'Falha ao inserir registros na tela Benefícios! Erro: 030320201526';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_benef_lot_carg :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 100220201015 | clone_orcamento_benef_lot_carg';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 100220201005 - ' . 'clone_orcamento_benef_lot_carg';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertAcordoColetivo($orc_id,$clone_orc_id){
        $value = 'Falha ao inserir registros na tela Acordo Coletivo! Erro: 110320201618';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_dissidio :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 110320201617 | clone_orcamento_dissidio';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 110320201616 - ' . 'clone_orc_dissidio';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    

    }

    public function scriptInsertBonus($orc_id,$clone_orc_id){
        $value = 'Falha ao inserir registros na tela Bonus! Erro: 110320201724.';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_bonus :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 110320201726 | clone_orcamento_bonus';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 110320201727 - ' . 'clone_orc_bonus';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;     

    }


    public function scriptInsertBeneficio($orc_id, $clone_orc_id){
        $value  = 'Falha ao inserir registros na tela Benefícios! Erro: 030320201527';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_beneficio :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 100220201000 | clone_orcamento_beneficio';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 100220200955 - ' . 'clone_orcamento_beneficio';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertCargosAreaSalario($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Aumentos Salariais! Erro: 030320201530';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_cargos_area_sal :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar clone_orcamento_cargos_area_sal. Erro: 100220200954';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir registro. Erro: 100220200948 - ' . 'clone_orcamento_cargos_area_sal';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertContratacoes($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Headcount Contratações! Erro: 030320201532';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_contratacoes :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200944 | clone_orcamento_contratacoes';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 100220200942 - ' . 'clone_orcamento_contratacoes';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertDemissoes($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Headcount Contratações! Erro: 030320201535';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_demissoes :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200940 | clone_orcamento_demissoes';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020938 - ' . 'clone_orcamento_demissoes';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertDespesas($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Headcount Despesas! Erro: 030320201540';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_despesas :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200936 | clone_orcamento_despesas';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020932 - ' . 'clone_orcamento_despesas';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertEventos($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Controle de Eventos! Erro: 030320201545';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_eventos :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200931 | clone_orcamento_eventos';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020928 - ' . 'clone_orcamento_eventos';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertHeadcount($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Headcount! Erro: 030320201550';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_headcount :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020927 | clone_orcamento_headcount';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020925 - ' . 'clone_orcamento_headcount';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertHeadcountHoraExtra($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Headcount Hora Extra! Erro: 030320201555';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_hora_extra :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020921 | clone_orcamento_hora_extra';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 100220200919 - ' . 'clone_orcamento_hora_extra';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertHoraExtraEvento($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Hora Extra! Erro: 030320201600';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_hora_extra_evento :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020917 | clone_orcamento_hora_extra_evento';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020915 - ' . 'clone_orcamento_hora_extra_evento';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertLotacao($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros do Orçamento! Erro: 030320201605';
        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_lotacao :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao inserir Lotação. Erro: 10022021030 | clone_orcamento_lotacao';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Lotação atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $this->deleteOrcamento($clone_orc_id);
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao inserir Lotação. Erro: 10022021020 - ' . 'clone_orcamento_lotacao';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertPremissas($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Premissias! Erro: 030320201610';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_premissas :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020912 | clone_orcamento_premissas';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020910 - ' . 'clone_orcamento_premissas';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertSalarioFuncionario($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Aumentos Salariais! Erro: 08022021215';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_salario_funcionario :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200856 | clone_orcamento_salario_funcionario';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_salario_funcionario';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertFerias($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Headcount Férias! Erro: 030320201517';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_ferias :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 08022021218 | clone_orcamento_ferias';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_ferias';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertPromocao($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Headcount Promoção! Erro: 08022021217';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_promocao :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 08022021218 | clone_orcamento_promocao';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_promocao';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function scriptInsertBeneficioLotFuncionario($orc_id, $clone_orc_id){
        $value  = 'Falha ao inserir registros na tela Benefícios Por Funcionário! Erro: 120320201618';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_benef_lot_func :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 120320201619 | clone_orcamento_beneficio';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 120320201620 - ' . 'clone_orcamento_benef_lot_func';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    

    }
 
    public function scriptProcedureInsertOrcamento($id_orc, $orcamento_param = ["ano", "descricao", "versao", "revisao"]){        
        /**
         * Criado uma procedure de insert no banco natureza.
         */
        $value = 'Falha ao inserir registros na tela Orçamento! Erro: 030320201620';
        DB::beginTransaction();

        try {                   
           
            $sql="EXEC insert_orcamento :id_orc, :ano, :descricao, :versao, :revisao, :output ";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':id_orc', $id_orc, \PDO::PARAM_INT );
            $stmt->bindParam(':ano', $orcamento_param['ano'], \PDO::PARAM_INT );
            $stmt->bindParam(':descricao', $orcamento_param['descricao'], \PDO::PARAM_STR );
            $stmt->bindParam(':versao', $orcamento_param['versao'], \PDO::PARAM_STR );
            $stmt->bindParam(':revisao', $orcamento_param['revisao'], \PDO::PARAM_STR );
            $stmt->bindParam(':output', $output_procedure,  \PDO::PARAM_INT,  \PDO::SQLSRV_PARAM_OUT_DEFAULT_SIZE);
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao Clonar o Orçamento! Erro: 030320201130 | insert_orcamento' .$output_procedure;
                goto saida;
            } 

            if($output_procedure == null){
                DB::rollBack();
                $retorno["status"]="error";
                $retorno['msg'] = "Falha ao Clonar o Orçamento!";
                $retorno['submsg']='Falha ao atualizar registro Orçamento. Erro: 310120201126' .$output_procedure;
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Orçamento atualizado com sucesso!";
            $retorno["clone_orc_id"]=$output_procedure;
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao Clonar o Orçamento. Erro: 310120201122';
            $retorno['submsg']='Falha ao fazer inserir Orçamento. Erro: 310120201123 - ' . $output_procedure;            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        
        return $retorno;                         
    }

    public function scriptInsert($table_entitie, $select, $colunas, $orc_id){        
        // sequencia das colunas devem seguir a sequencia da select.
        $table = $table_entitie->getTable();
        
        $insert = DB::raw("
                INSERT INTO $table (                   
                    $colunas
                    , created_at
                    , updated_at
                    ) 
            " . $select );             
        
        // dd("insert", $insert);
        DB::beginTransaction();

        try {

            $result = DB::connection()->insert(
                $insert , [$orc_id]
            );            

            if(!$result){
                $retorno["status"]="error";
                $retorno['msg'] = $table_entitie->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer inserir registro. Erro: 30012021510';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";  
            $retorno["id_inserido"] = $result;
        } catch (\Exception $e) {
            DB::rollBack();
            // dd("asdfasdfasdfasdfasdf". $e);
            abort(500,'Falha ao inserir registro. Erro: 30012021515.'.$e);   
        }
        saida:
         
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
          
        return $retorno;   
    }
    
    public function scriptSelectInsert($param_select_insert){
        // sequencia das colunas devem seguir a sequencia do insert.
        $colunas = '';
        $from = '';
        $where = '';
        $group_by = '';
        $order_by = '';

        if(isset($param_select_insert['colunas']) && !is_null($param_select_insert['colunas'])){
            $colunas = $param_select_insert['colunas'];            
        }
        if(isset($param_select_insert['from']) && !is_null($param_select_insert['from'])){
            $from = $param_select_insert['from'];            
        }
        if(isset($param_select_insert['where']) && !is_null($param_select_insert['where'])){
            $where = $param_select_insert['where'];            
        }
        if(isset($param_select_insert['group_by']) && !is_null($param_select_insert['group_by'])){
            $group_by = $param_select_insert['group_by'];            
        }
        if(isset($param_select_insert['order_by']) && !is_null($param_select_insert['order_by'])){
            $order_by = $param_select_insert['order_by'];            
        }
        
        $select = "select 
                        {$colunas}
                        , getDate() created_at
                        , NULL updated_at  
                    FROM                       
                    {$from}
                    {$where}
                    {$group_by}
                    {$order_by}
            ";
        return $select;
    }

    public function scriptMergeInsertUpdate($table_entitie, $select, $array_merge){
        $table = $table_entitie->getTable();
        
        $array_on_colunas_chave_ex_primaria = '';
        $array_campos_update = '';
        $array_colunas_insert = '';
        $array_value_insert = '';
        
        for($i = 0; $i < count($array_merge['array_on_colunas_chave_ex_primaria']); $i++){
            ($i==0) ? $array_on_colunas_chave_ex_primaria .= " target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} " :
                      $array_on_colunas_chave_ex_primaria .= " AND target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                 source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} ";
        }
        
        for($i = 0; $i < count($array_merge['array_campos_update']); $i++){
            $up = '';
            ($array_merge['array_campos_update'][$i]=='updated_at') ? $up = "getDate()" : $up = "source.{$array_merge['array_campos_update'][$i]}";
            ($i==0) ? $array_campos_update .= " target.{$array_merge['array_campos_update'][$i]}=
                                                source.{$array_merge['array_campos_update'][$i]} " :
                      $array_campos_update .= " , target.{$array_merge['array_campos_update'][$i]}=
                                                    {$up} ";
        }
        
        for($i = 0; $i < count($array_merge['array_colunas_insert']); $i++){
            ($i==0) ? $array_colunas_insert .= " {$array_merge['array_colunas_insert'][$i]} " :
                      $array_colunas_insert .= ", {$array_merge['array_colunas_insert'][$i]} ";

            ($i==0) ? $array_value_insert .= " source.{$array_merge['array_colunas_insert'][$i]} " :
                      $array_value_insert .= ", source.{$array_merge['array_colunas_insert'][$i]} ";
        }
        
        $merge = "
        MERGE {$table} as target
                USING
                (
                    {$select}
                ) AS source
                ON
                    {$array_on_colunas_chave_ex_primaria}
                WHEN MATCHED 
                    THEN UPDATE SET
                        {$array_campos_update}
                WHEN NOT MATCHED BY target
                    THEN
                        INSERT (
                            {$array_colunas_insert}
                            )values(
                            {$array_value_insert}
                            )
            ;
        ";
        
        DB::beginTransaction();

        try {
              
            $pdo = DB::connection()->getPdo();
           
            $query = $pdo->prepare($merge);
            // dd('merge', $query);
            if ($query->execute()) { 
                $count = $query->rowCount();
            }               
            
            if(!$query){
                $retorno["status"]="error";
                $retorno['msg'] = implode(",", $query->errorInfo());
                $retorno['submsg']='Falha ao atualizar registro. Erro: 310120201126';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="{$count} Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 310120201122';
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 310120201123 - ' .implode(",", $query->errorInfo());            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd('retorno', $retorno);
        return $retorno; 
        
    }

    public function scriptInsertCloneHoraExtra($orc_id, $clone_orc_id, $user_id){
        $value = 'Falha ao inserir registros na tela Hora Extra! Erro: 030320201625';

        DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_hora_extra :orc_id, :clone_orc_id, :user";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':user', $user_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 28022021130 | clone_hora_extra';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 28022021119 - ' . 'clone_hora_extra';            
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

    public function getTableAlias($alias, $entitie){
        $alias_table = $entitie->getTable().'_'.$alias;
        $tb_alias = $entitie->getTable();       
        $tb_alias = $tb_alias . " AS {$alias_table}";

        $result = [
            'alias' => $alias_table,
            'table' => $tb_alias
        ];
        return $result;
    }   

    public function colEntitie($entitie, $campos_remover){
        $result = implode(',', array_diff($entitie->getNomeColunas(), $campos_remover));

        return $result;
    }

    public function colEntitieSelectDiff($entitie, $campos_remover){
        $result = array_diff($entitie->getNomeColunas(), $campos_remover);

        return $result;
    }

    public function deleteOrcamento($orc_id){        
        $Orcamento = new Orcamento();

        DB::beginTransaction();
       
        try{
            
            if(!$Orcamento->deleteParent($data['id'])){  
                $this->setError('Falha ao deletar o Orçamento. Erro: 030320201105 ' .$this.getErrosFlatted());
                DB::rollBack();
                return false;                                  
            }
            
            DB::commit();
                
            } catch (Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao deletar o Orçamento. Erro: 080120201624.');
        }
        
        return array('msg'=>"Orçamento deletado!",'status'=>"success");
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

}
