<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoTurno;
use App\Modules\Natureza51\Repositories\RepoTurma;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\Turma;
use Illuminate\Support\Facades\DB;

class RepoOrcTurma extends RepoOrcamento {

    protected $model_name_space='App\Modules\Natureza51\Entities\OrcTurma';     

    public function listOrcTurma($orc_id){  

      $return = $this->getModelEntity()::with([
        'getTurno'=>function($query){
        }
      ])
      ->where('orc_id', $orc_id)
      ->get()
      ->toArray();

      for ($i=0; $i < count($return) ; $i++) { 

        $return[$i]['des_turno_trab']=$return[$i]['get_turno']['des_turno_trab'];
        
        // $return[$i]['des_turma_trab']=$return[$i]['des_turma_trab'];
        unset($return[$i]['get_turno']);
     }      
    
      return $return;
    }    

    public function listOrcGroupTurma($orc_id){        
        $turma = new Turma();
        $result = $this->getModelEntity()->join(
            $turma->getTable(),
            $turma->getColunaAlias('id'),'=', $this->getModelEntity()->getColunaAlias('turma_id')
            )
            ->select(
                $this->getModelEntity()->getColunaAlias('des_turma_trab'),
                DB::raw('COUNT(*) qtd_turnos')
              )
              ->where('orc_id', $orc_id)
              ->groupBy($this->getModelEntity()->getColunaAlias('des_turma_trab'))
              ->orderBy('qtd_turnos','desc')
              ->get()->toArray();
        
              return $result;
        
      }
    
}
