<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoEventos;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcLotacao;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Facades\DB;

class RepoOrcamento extends RepositoryNat51
{
    protected $orc_atual=null; 
    
   // protected $model_name_space='App\Modules\Natureza51\Entities\Orcamento';
    protected $orc_name_space='App\Modules\Natureza51\Entities\Orcamento';
    protected $form_rules=[];
    protected $rules_msg=[]; 
    private $orc_instance_repo;
    private $orc_entity;
    protected $repo_event;
    protected $entity_headcount;
    protected $entity_lotacao;

    private $cal_orc_repo;
    private $calc_orc_name_space='App\Modules\Natureza51\Repositories\RepoCalcOrcamento';
    private $orc_fk_name="orcamento_id";
    const  ORC_FK_NAME_DEFAULT="orcamento_id";
        

    const STATUS_PENDENTE=1;
    const STATUS_EM_ANDAMENTO=2;
    const STATUS_ENVIADO=3;
    const STATUS_REABERTO=4; 
    const STATUS_EM_CONFERENCIA=5;
    const STATUS_LIBERADO=6;
    const STATUS_FINALIZADO=7; 
    const STATUS_APROVADO=8;
    const STATUS_EM_EXECUCAO = 9; 
    const STATUS_ENVIADO_SISTEMA = 10;
    CONST STATUS_REJEITADO = 11;
    const STATUS_EXCLUIDO = 12;
    
    use \App\Core\Traits\StatusTrait;
    
    function __construct() {
        
        if(!$this->getModelNameSpace()){
            $this->setModelNameSpace($this->getOrcNameSpace());
        }
        if($this->isChildren()){
            $this->repoOrcNewInstance();
        }       
        
        $this->repo_event = new RepoEventos();
        $this->entity_lotacao = new OrcLotacao();
        $this->entity_headcount = new OrcamLotCargoHeadcount(); 
        parent::__construct();
    }
    
    public function setOrcamento(\App\Modules\Natureza51\Entities\Orcamento $value=null){
        $this->orc_atual=$value;
        $this->setOrcInstanceRepo();
        return $this;
    }
    /**
     * @TODO ALUISIO FERREIRA DE SOUSA 30/11/2019
     * Será chamado apenas pelo setOrcamento
     * Para verificar se tem ou não uma instancia do repositorio do Orcamento basta chamar o metodo has() 
     * @return $this
     */
    private function setOrcInstanceRepo(){
       if(!$this->has()){
            $this->orc_instance_repo=null;
            return $this;
       }
        $this->orc_instance_repo=$this->getOrcInstanceNew();
        $this->orc_instance_repo->getModelEntity()->fill($this->getAtual()->getAttributes());
        return $this;
    }

    function getOrcInstanceNew(){
         return new RepoOrcamento();
    }
    
    function getOrcInstanceRepo(){ return $this->orc_instance_repo; }
    /**
     * @TODO ALUISIO FERREIRA DE SOUSA 30/11/2019
     * Indica se a instancia atual é se uma subclasse de orcamento ou é a propria(OrcamentoRepositiry)
     * @return type
     */
    function isChildren(){ return $this->getModelNameSpace()!= $this->getOrcNameSpace(); }
    function isParent(){ return !$this->isChildren(); }
    public function getAtual(){ return $this->orc_atual; }
    public function has(){
        $orc=$this->orc_atual;
        if(!$orc){
            
            return false;
        }
        if(!isset($orc->id)){
            return false;
        }
        if(intval($orc->id)<=0){
            return false;
        }   
        return true;
    }
   
    public function isEditable(){
        if(!$this->has()){
            return false;
        }
        $orc=$this->getAtual();
        return true;
    } 
    public function canEdit(){
        if(!$this->has()){
            return false;
        }
        return true;
    }
    public function canDelete(){
        if(!$this->has()){
            return false;
        }
        return true;
    }
    public function isOwn(){
        
        if(!$this->has()){
            return false;
        }
        return true;
    }
    private function repoOrcNewInstance(){
        $class_name='\App\Modules\Natureza51\Repositories\RepoOrcamento';
        $this->orc_instance_repo = new $class_name();
        return $this->entitieOrcNewInstance();
    }
    private function entitieOrcNewInstance(){
        $this->orc_entity=!$this->getOrcInstanceRepo()? null : $this->getOrcInstanceRepo()->getModelEntity(); //new {$this->getModelNameSpace()}() ;
        return $this;
    }
    public function getOrcNameSpace(){ return $this->orc_name_space; } 
    public function getModelEntityOrc() { return $this->orc_instance_repo; }
    public function putOrcamentoIdOnData($dados, $value, $orcamento_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($orcamento_id_name) ? 'orcamento_id' : $orcamento_id_name, $value);
        return $retorno;
        
    }
    public function extractOrcamentoIdFromData($dados, $orcamento_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $orcamento_id_name=empty($orcamento_id_name)? 'orcamento_id' : $orcamento_id_name;
        
        return isset($dados[$orcamento_id_name]) ? $dados[$orcamento_id_name] : 0;   
    }

    /**
     * @author Samuel Domingos de Lia
     * @param $dados Array with data
     * @param $lotacao_id_name Field name for search
     */
    public function extractLotacaoIdFromData($dados, $lotacao_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $lotacao_id_name=empty($lotacao_id_name)? 'lotacao_id' : $lotacao_id_name;
        
        return isset($dados[$lotacao_id_name]) ? $dados[$lotacao_id_name] : 0;   
    }

    /**
     * @author Samuel Domingos de Lia
     * @param $dados Array with data
     * @param $value Value of field name
     * @param $lotacao_id_name Field name for put
     */
    public function putLotacaoIdOnData($dados, $value, $lotacao_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($lotacao_id_name) ? 'lotacao_id' : $lotacao_id_name, $value);
        return $retorno;
        
    }


    public function putCargoIdOnData($dados, $value, $cargo_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($cargo_id_name) ? 'cargo_id' : $cargo_id_name, $value);
        return $retorno;
        
    }
    public function extractCargoIdFromData($dados, $cargo_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $cargo_id_name=empty($cargo_id_name)? 'cargo_id' : $cargo_id_name;
        
        return isset($dados[$cargo_id_name]) ? $dados[$cargo_id_name] : 0;   
    }

    public function putTurmaIdOnData($dados, $value, $turma_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($turma_id_name) ? 'orc_turma_id' : $turma_id_name, $value);
        return $retorno;
        
    }
    public function extractTurmaIdFromData($dados, $turma_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $turma_id_name=empty($turma_id_name)? 'orc_turma_id' : $turma_id_name;
        
        return isset($dados[$turma_id_name]) ? $dados[$turma_id_name] : 0;   
    }

 
    /** 
     * 
     * @param array $data
     * @param type $call_back_success
     * @param type $call_ball_error
     */
    public function createOrc(array $data, $call_back_success=null, $call_ball_error=null) {
        // dd('$create');
        $repo_script_calc = new RepoOrcScriptCalculos();
        
        if($this->isChildren() && $this->has()===false ){
            $this->setError(['Selecione um orçamento para finalizar a operação.', 'Erro: 301120191601']);
            return false;
        }
        

        DB::beginTransaction();
        try {
        
            if(($salvou= parent::create($data)) ===false ){
                return empty($call_ball_error) ? $salvou : $call_ball_error($this->getError(), $data, $salvou);
            }
            // dd($repo_script_calc->createCalcCargoArea($salvou->id));
            $result =$repo_script_calc->createCalcCargoArea($salvou->id);
            if($result['status']=='error'){
                $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 100320201027.');
                return false;
                
            }

            // dd($result);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir o orçamento. Erro: 240220201020');
        }

        


        return empty($call_back_success) ? $salvou : $call_back_success($salvou, $data);
    }
       public function getOrcFkNameDefault(){ return self::ORC_FK_NAME_DEFAULT;}
       public function getOrcFkName(){ return empty($this->orc_fk_name) ? $this->getOrcFkNameDefault() : $this->orc_fk_name; }
           protected function setOrcFkName($value){
        $this->orc_fk_name= strtolower(trim($value));
        return $this;
    }
 
        /**
     * @author Samuel Domingos de Lima 17/05/2020
     * @param $data Array with values
     * @param $call_back_success Pass a success call back function 
     * @param $call_ball_error Pass a error call back function 
     */
    public function checkHeadcount($data, $call_back_success=null,$call_back_error=null){
       
        $lot = $this->getEntityLotacao()->where('id',$this->extractLotacaoIdFromData($data))->first();
        if(!$lot){
            $this->setError('Selecione a lotação para continuar a operação.<br/> Erro: 140120201103.');
            return false;
        }
        if($lot->status==$this->getStatusEnviado() || $lot->status==$this->getStatusEmConferencia() || $lot->status==$this->getStatusLiberado()){
            $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 140120201130.');
            return false;
        }
        
        if(!$this->getEntityHeadcount()->where([
            'orc_cargo_id'=> $this->extractCargoIdFromData($data),
            'lotacao_id' => $this->extractLotacaoIdFromData($data),
            'orc_turma_id'=>$this->extractTurmaIdFromData($data)
            ])->get()){
                
            $this->setError('Dados não cadastrados em Headcount.<br/> Erro: 130120201155.');
            return false;
        }
        if($this->getModelEntity()->getTable() == 'tbl_orc_promocao'){
            unset($data['cargo_id']);
            unset($data['orc_turma_id']);
            // unset($data['turma_atual_id']);
        }
        // dd("head", $data); 
        $salvou =parent::create($data);
 
        if($salvou === false){
            return empty($call_ball_error) ? $salvou : $call_back_error($this->getError(), $data, $salvou);
        }
        if($lot->status == $this->getStatusPendente()){
            $lot->status = $this->getStatusEmAndamento();
            $lot->save();
        }
        return empty($call_back_success) ? $salvou : $call_back_success($salvou, $data);

    }

    public function checkUpdateOrc($row_data){
        dd($row_data);
    }

     public function checkUpdateFore($row_data){
        // dd($this->extractOrcamentoIdFromData($row_data,'orc_id'));
        $orc = new RepoOrcamento();
        $orc_atual = $orc->find($this->extractOrcamentoIdFromData($row_data,'orc_id'));
        if($orc_atual->status_orc != $this->getStatusFinalizado()){
            return false;
        } 

        // dd($orc_atual->status_orc);

        return true;
    } 
         public function listAll($orc_id){

        $result= $this->isParent() ? $this->listar() : $this->getModelEntity()
                ->where($this->getOrcFkName(),'=', $orc_id)->get();
        /***
         * @TODO Aluisio Ferreira de Sousa 12/12/2019
         * Verifica a necessidade de colocar a opção de carregar com o with
         * 
         * ->with([
            'getCargo'=>function($query){


            }
        ])
         */
        
        if(!($orc = $result->first())){
           $this->setError(['Informe um orçamento','Erro: 021220191834']);
           return false;
        }
        
        $orc_f=$orc->getOrcamento();
        
        if(!$orc_f){
             $this->setError(['Orçamento não encontrado.', 'Erro: 121220191452']);
            return false;
        }
        $atual=$orc_f->first();
        
        if(!$atual){
             $this->setError(['Orçamento não encontrado.', 'Erro: 121220191453']);
            return false;
        }
        
        if($this->setOrcamento($atual)->has()===false){
            $this->setError(['Orçamento não encontrado.', 'Erro: 121220191454']);
            return false;
        }
        if($this->isOwn()===false){
            $this->setError(['Você não tem permissão para acessar estas informações.', 'Erro: 121220191455']);
            return false;
        }
        
        
        return $result->count()==0 ? []: $result;
       
    }
    public function getEventsOfHour(){
        return $this->getRepoEvent()->getModelEntity()->select('id')
        // ->where('tipo_evento_id',3)
        ->get(); 
    } 

    public function getRepoEvent(){return $this->repo_event;}
    
    protected function setCalOrcRepo($cal_orc_repo_instance=null){
        $this->cal_orc_repo=!$cal_orc_repo_instance ? (new RepoCalcOrcamento()) : $cal_orc_repo_instance;
        return $this;
    }
    protected function getCalcOrcRepo(){ return $this->cal_orc_repo; }
    
    public function getCalcOrcRepoData($origem_id_array){
        $tabel_name=$this->getModelEntity()->getTable();
        $a= $this->getCalcOrcRepo()->getModelEntity()
                ->where('tbl_origem','=',$tabel_name)
                ->whereIn('origem_id', $origem_id_array)->get();
        //dd('adds4454ewew', $a, $tabel_name, $origem_id_array);
        return $a;
    }
    
        /**
     * @TODO ALUISIO FERREIRA DE SOUSA 16/12/2019
     * Mesclas os resultados de uma tabela com a calcOrcamentos
     * @param COLLECTION $dados
     * @return ARRAY|MIXED  é retornado um array com os atributos da tabela principal mesclado com as propriedades da tabela
     * calc orcado
     */
    public function mergWithCalcOrc(\Illuminate\Support\Collection $dados, $key_name='id'){
        
        $calc_orc=$this->getCalcOrcRepoData($dados->pluck($key_name));
        
        if($calc_orc->count()==0){
            return $dados->toArray();
        }
        $retorno=[];
        $dados->each(function($item, $key) use(&$retorno, &$calc_orc, $key_name){
           $calc_orc_fields= ($exist=$calc_orc->where('origem_id','=', $item->{$key_name})->first())===false ? []: $exist->getAttributes();
           $retorno[]=array_merge($item->getAttributes(),$calc_orc_fields); 
        });
        return $retorno;
    }
    
    
    /**
     * @param array $clausule Pass an array of keys and values ​​for verification in the database
     * @return boolean indicate if has data on DB 
     * @author Samuel Domingos de Lima 06/01/2020
     */

    public function hasDataOnDB($clausule){
        return (!empty($this->getModelEntity()->where($clausule)->get()->toArray()))? true:false;
    }

     /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function pendingStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120200938.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusPendente();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function inProgressStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();

        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120200939.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEmAndamento();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function sendStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201022.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEnviado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function reopenedStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201040'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusReaberto();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function inConferenceStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201108'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEmConferencia();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function releasedStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201109.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusLiberado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function completedStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 290120200900.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusFinalizado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function inExecutionStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 310120201227.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEmExecucao();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    public function sendSystemStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 040220201050.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEnviadoSistema();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }


    public function approvedStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 0602202500946.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusAprovado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    
    }

    public function rejectStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 0602202500946.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusRejeitado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function excluidoStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 0602202500946.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusRejeitado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    private function getEntityHeadcount(){return $this->entity_headcount;}
    private function getEntityLotacao(){ return $this->entity_lotacao;}

    public function getStatusPendente(){
        return self::STATUS_PENDENTE;
    }
    public function getStatusEmAndamento(){
        return self::STATUS_EM_ANDAMENTO;
    }
    public function getStatusEnviado(){
        return self::STATUS_ENVIADO;
    }
    public function getStatusReaberto(){
        return self::STATUS_REABERTO;
    }
    public function getStatusEmConferencia(){
        return self::STATUS_EM_CONFERENCIA;
    }
    public function getStatusLiberado(){
        return self::STATUS_LIBERADO;
    }
    public function getStatusFinalizado(){
        return self::STATUS_FINALIZADO;
    }

    public function getStatusAprovado(){
        return self::STATUS_APROVADO;
    } 

    public function getStatusEmExecucao(){
        return self::STATUS_EM_EXECUCAO;
    }
    public function getStatusEnviadoSistema(){
        return self::STATUS_ENVIADO_SISTEMA;
    } 
    public function getStatusRejeitado(){
        return self::STATUS_REJEITADO;
    }

    public function getStatusExcluido(){
        return self::STATUS_EXCLUIDO;
    }
    
    
    /**
     * @OVERIDE create of App\Core\Repositories\Eloquent\Repository->create
     * ALUISIO FERREIRA DE SOUSA 28/02/2020
     * Inseri um novo orcamento Não será utilizado pelos metodos filhos
     * 
     */
    public function create($dados){
         
        return parent::create($dados);
         
         
         
        /**
         * Verifica se a instance é de um orcamento 
         * caso seja de um repositorio filho retorna um erro.
         */
        if(!$this->isParent()){
            $this->setError('Não é possível criar um novo orçamento. O repositorio de orçamento não foi inicializado corretamento . Erro: 28022020.');
            return false;
        }
        dd('xxxaasada', 
           $dados,
           dateToBrFormat($dados['data_inicio'], 'Y-m-d')
        );
        // return parent::create($form_data);
    }
    /**
     * ALUISIO FERREIRA DE SOUSA 28/02/2020
     * Validações para o cadastro do orcamento(tbl_orcamento);
     * @param $dados MIXED|ARRAY Obrigatorio Array associativo com os campos e dados para salvar o orcamento.
     * @param $tipo_op STRING Opcional indica para qual tido de operação será a validação. O padrão é add. Valores possiveis: add= Adicionar, edt=editar, del=Deletar;
     * @return  boolean|String Caso contenha erro oo retorno será uma string se tudo estiver OK o retorno será TRUE
     */
    private function orcValidate($dados, $tipo_op='add'){
        $fillable = [         
        'empresa_id', 'cod_orcamento',  'status_aprovacao',
        'responsavel_id', 'status_orc', 
            'versao', 
            'revisao', 
          'responsavel_tec_id',
        
    ];
        if(!isset($dados['ano'])){
            return 'Preencha o campo ano';
        }
        $dados['ano']=intval($dados['ano']);
        
         $ano_atual=date('Y');
        /**
         * @todo Verifica se um orçamento tem que ser sempre Ano+1
         * vide as tarefa #1f5041 (https://app.clickup.com/t/1f5041)
         */
        if($dados['ano']< $ano_atual){
            return 'Preencha o campo ano, com um valor que corresponda um ano válido. Ex: 2019.';
        }
        
        if(!isset($dados['descricao_orc'])){
            return 'Preencha o campo descrição.';
        }
        
        $dados['descricao_orc']=trim($dados['descricao_orc']);
        
        if(empty($dados['descricao_orc'])){
            return 'Preencha o campo descrição.';
        }
        
        
        if(!isset($dados['versao_desc'])){
            return 'Preencha o campo observação da versão.';
        }
        
        $dados['versao_desc']=trim($dados['versao_desc']);
        
        if(empty($dados['versao_desc'])){
            return 'Preencha o campo observação da versão.';
        }        
        
         if(!isset($dados['revisao_desc'])){
            return 'Preencha o campo observação da revisão.';
        }
        
        $dados['revisao_desc']=trim($dados['revisao_desc']);
        
        if(empty($dados['revisao_desc'])){
            return 'Preencha o campo observação da revisão.';
        }
        
        if(!isset($dados['data_inicio'])){
            return 'Preencha o campo data de inicio do orçamento.';
        }
        if(!isset($dados['data_fim'])){
            return 'Preencha o campo data de fim do orçamento.';
        }
        $ini_str=trim($dados['data_inicio']);
        $fim_str=trim($dados['data_fim']);
        
        if(empty($ini_str)){
            return 'Preencha o campo data de inicio do orçamento.';
        }
        if(empty($fim_str)){
            return 'Preencha o campo data de fim do orçamento.';
        }
        $format_date_requested='Y-m-d';
        $dt_init= dateToBrFormat($ini_str, null, true);
        $fim_str= dateToBrFormat($fim_str, null, true);
        
        if($dt_init===false){
            return 'No campo data de inicio informe uma data valida. Ex: 29/02/2020';
        }
                
        if($fim_str===false){
            return 'No campo data de fim informe uma data valida. Ex: 29/02/2020';
        }
        
         $ano_inicio=intval($dt_init->format('Y'));
         
        if($dados['ano'] > $ano_inicio ){
            return 'O ano de inicio Não pode ser anterior ao ano do orçamento.';
        }
        
        if($dados['ano']> intval($dt_init->format('Y'))){
            
        }
        
        //'mes_ini_frc'
        
        return true;
    }

    public function updateParent($data_request, $id){
        return parent::update($data_request, $id);
    }
}
