<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

use Illuminate\Database\Eloquent\Model;

class RepoPlanoLotacaoTipo extends RepositoryNat51
{
   protected $model_name_space='App\Modules\Natureza51\Entities\PlanoLotacaoTipo';

   protected $form_rules=[
       'plano_lotac_id'=>'required',
        'cod_tipo'=>'required'
   ];
   protected $rules_msg=[
    'plano_lotac_id.required'=>'O campo Cód. Plano Lotação é obrigatório',
    'cod_tipo.required'=>'O campo Cód. Tipo é obrigatório'
   ];

  public function listar(){
     $a=$this->allWith([
        'getPlanoLotacao'=>function($query){
        }
     ])->toArray();

      for($i=0; $i<count($a); $i++){
         $a[$i]['des_plano_lotac']=$a[$i]['get_plano_lotacao']['des_plano_lotac'];
         unset($a[$i]['get_plano_lotacao']);
      }
      return $a;
  }
}
