<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoSetores extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Setores';
    
    protected $form_rules=['sigla_setor'=>'required|string|max:250|min:1',
                           'descricao_setor'=>'required|string|max:250|min:1',
                           'unidade_lotacao'=>'required',
                           'matricula_responsavel'=>'required',
                           'nome_responsavel'=>'required',
                           'cod_processo'=>'required',
                           'id_grupo' => 'required|exists:tbl_grupo,id_grupo',                           
                           'id_empresa' => 'required|exists:tbl_empresa,cod_empresa',
                           'id_filial' => 'required|exists:tbl_filial,id_filial',
                           'id_departamento' => 'required|exists:tbl_departamento,id_departamento',                           
                           'id_processo' => 'required|exists:tbl_processo,id_processo',
                           'id_centro_custo' => 'required|exists:tbl_ccusto,id_centro_custo',
                         ];

    protected $rules_msg=['sigla_setor.required'=>'O campo nome é obrigatório',
                          'sigla_setor.max'=>'O campo nome aceita até 250 caracteres',
                          'descricao_setor.required'=>'O campo nome é obrigatório',
                          'descricao_setor.max'=>'O campo nome aceita até 250 caracteres',                          
                          'unidade_lotacao.required'=>'O campo nome é obrigatório',
                          'matricula_responsavel.required'=>'O campo nome é obrigatório',
                          'nome_responsavel.required'=>'O campo nome é obrigatório',
                          'cod_processo.required'=>'O campo nome é obrigatório',
                          'id_empresa.required'=>'O campo nome é obrigatório',
                          'id_filial.required'=>'O campo nome é obrigatório',
                          'id_grupo.required'=>'O campo nome é obrigatório', 
                          'id_departamento.required'=>'O campo nome é obrigatório',
                          'id_processo.required'=>'O campo nome é obrigatório',
                          'id_centro_custo.required'=>'O campo nome é obrigatório',                          
                        ];  
}
