<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoTurno;
use App\Modules\Natureza51\Entities\OrcTurma;
use Illuminate\Support\Facades\DB;

class RepoTurma extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Turma';
     protected $form_rules=[

                           
                           'turno_id'=>'required|exists:tbl_turno,cdn_turno_trab',
                           'cdn_turma_trab'=>'required|unique:tbl_turma,cdn_turma_trab',
                         ];

    protected $rules_msg=[
                           
                           'turno_id.required'=>'O campo turno é obrigatório',
                           'turno_id.exists'=>'O campo turno é obrigatório',           
                           'cdn_turma_trab.required' => 'O campo Cód. Turma é obrigatório',                  
                           'cdn_turma_trab.unique' => 'Cód. Turma já foi cadastrado'
                           
                                               
                        ]; 
 

    public function listaTurmaTurno(){
      $turno = new RepoTurno();
      $turma = $this->getModelEntity();
      $list = $turma->join($turno->getModelEntity()->getTable(),$turma->getColunaAlias('turno_id'),$turno->getModelEntity()->getColunaAlias('id'))
      ->select(
        $turma->getColunaAlias('turno_id'),
        $turma->getColunaAlias('evento_adc_id'),
        $turma->getColunaAlias('evento_ext_id'),
        $turma->getColunaAlias('adic_noturno'),
        $turma->getColunaAlias('extra_noturno'),
        $turma->getColunaAlias('id'),$turma->getColunaAlias('des_turma_trab'),$turma->getColunaAlias('cdn_turma_trab'),$turno->getModelEntity()->getColunaAlias('des_turno_trab'))->get()->toArray();

      for($i=0;$i<count($list);$i++){
        $dados[$i]=array_merge($list[$i],array("description"=>$list[$i]['cdn_turma_trab'].' - '.$list[$i]['des_turma_trab']));
    }

      return $dados;

    }
    public function update(array $data,$id,$attribute="id"){

      $this->form_rules['cdn_turma_trab'].=','.$id;

      return parent::update($data,$id,$attribute);

    }

    public function listGroupTurma(){
      $data = $this->getModelEntity()->select('cdn_turma_trab','des_turma_trab', DB::raw('COUNT(*) qtd_turnos'))
        ->groupBy('des_turma_trab','cdn_turma_trab')
        ->orderBy('qtd_turnos','desc')
        ->get()->toArray();

        for($i=0;$i<count($data);$i++){
          $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_turma_trab'].' - '.$data[$i]['des_turma_trab']));
      }
      return $dados;
    }
    
    
}
