<?php

use Illuminate\Http\Request;
use Illuminate\Support\Arr;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|Aluisio Ferreira de Sousa 20/08/2019
| 
| 
| 
|
*/

Route::get('home-teste', function () {
    return view('welcome');
});


// Route::group(['middleware'=>'insti'], function(){

        // Route::group(['middleware'=>'auth:insti'], function(){
           /**
            * Exemplo de rota get com parametro e filtro de parametro
            */
           Route::get('api/url-teste/{id}/listar', ['as'=>'alias_url_listar', 'uses'=>'TesteCtrl@listar'])
                   ->where(['id'=>'[0-9]+']);
           
           /**
            * Exemplo de rota post com parametro e filtro de parametro
            */
           Route::post('api/url-teste/{id}/acao', ['as'=>'alias_url', 'uses'=>'TesteCtrl@acao'])
                        ->where(['id'=>'[0-9]+']);
           
        /** ========================= AREA ======================== */   
        Route::get('area/listar', 'AreaController@listar');
        Route::post('area/update', 'AreaController@update');
        Route::post('area/insert', 'AreaController@insert');
        Route::post('area/delete', 'AreaController@delete');

        Route::get('script_calculo', 'AreaController@gerar');
        
        /** ========================= DEPARTAMENTO ======================== */   
        Route::get('departamento/listar', 'DepartamentoController@listar');
        Route::post('departamento/update', 'DepartamentoController@update');
        Route::post('departamento/insert', 'DepartamentoController@insert');
        Route::post('departamento/delete', 'DepartamentoController@delete');

        /** ========================= DIRETORIA ======================== */   
        Route::get('diretoria/listar', 'DiretoriaController@listar');
        Route::post('diretoria/update', 'DiretoriaController@update');
        Route::post('diretoria/insert', 'DiretoriaController@insert');
        Route::post('diretoria/delete', 'DiretoriaController@delete');

        /** ========================= SETORES ======================== */
        Route::get('setores/listar', 'SetoresController@listar');
        Route::post('setores/update', 'SetoresController@update');
        Route::post('setores/insert', 'SetoresController@insert');
        Route::post('setores/delete', 'SetoresController@delete');

        /** ========================= MÓDULOS ======================== */
        Route::get('modulos/listar', 'ModulosController@listar');
        Route::post('modulos/update', 'ModulosController@update');
        Route::post('modulos/insert', 'ModulosController@insert');
        Route::post('modulos/delete', 'ModulosController@delete');

        /** ========================= TELAS ======================== */
        Route::get('tela/listar', 'TelaController@listar');
        Route::post('tela/update', 'TelaController@update');
        Route::post('tela/insert', 'TelaController@insert');
        Route::post('tela/delete', 'TelaController@delete');

        /** ========================= USUÁRIO ======================== */
        Route::get('usuario/listar', 'UsuarioController@listar');
        Route::post('usuario/update', 'UsuarioController@update');
        Route::post('usuario/insert', 'UsuarioController@insert');
        Route::post('usuario/delete', 'UsuarioController@delete');

        /** ========================= ENDEREÇO ======================== */
        Route::get('endereco/listar', 'EnderecoController@listar');
        Route::post('endereco/update', 'EnderecoController@update');
        Route::post('endereco/insert', 'EnderecoController@insert');
        Route::post('endereco/delete', 'EnderecoController@delete');
 
        /** ========================= BENEFICIO ======================== */
        Route::get('beneficio/listar', 'BeneficioController@listar');
        Route::post('beneficio/update', 'BeneficioController@update');
        Route::post('beneficio/insert', 'BeneficioController@insert');
        Route::post('beneficio/delete', 'BeneficioController@delete');


        /** ========================= DESPESAS ======================== */
        Route::get('despesas/listar', 'DespesasController@listar');
        Route::post('despesas/update', 'DespesasController@update');
        Route::post('despesas/insert', 'DespesasController@insert');
        Route::post('despesas/delete', 'DespesasController@delete');

        Route::get('funcionario/listar', 'FuncionarioController@listar');
        Route::post('funcionario/update', 'FuncionarioController@update');
        Route::post('funcionario/insert', 'FuncionarioController@insert');
        Route::post('funcionario/delete', 'FuncionarioController@delete');

        Route::get('turma/listar', 'TurmaController@listar');
        Route::get('turma/turno/listar', 'TurmaController@listaTurmaTurno');
        Route::get('turma/group/listar', 'TurmaController@listGroupTurma');
        Route::post('turma/update', 'TurmaController@update');
        Route::post('turma/insert', 'TurmaController@insert'); 
        Route::post('turma/delete', 'TurmaController@delete');

        /** ========================= Orc Turma ======================== */
        Route::get('orcamento/{orc_id}/orcturma/listOrcTurma', 'OrcTurmaController@listOrcTurma');
        Route::get('orcamento/{orc_id}/orcturma/listOrcGroupTurma', 'OrcTurmaController@listOrcGroupTurma');
        Route::post('orcamento/{orc_id}/orcturma/insert', 'OrcTurmaController@inserirOrcTurma');
        Route::post('orcamento/{orc_id}/orcturma/deletar', 'OrcTurmaController@deletar');

        Route::get('turno/listar', 'TurnoController@listar');
        Route::post('turno/update', 'TurnoController@update');
        Route::post('turno/insert', 'TurnoController@insert');
        Route::post('turno/delete', 'TurnoController@delete');

        Route::get('centroCusto/listar', 'CentroCustoController@listar');
        Route::post('centroCusto/update', 'CentroCustoController@update');
        Route::post('centroCusto/insert', 'CentroCustoController@insert');
        Route::post('centroCusto/delete', 'CentroCustoController@delete');

        Route::get('cargo/listar', 'CargoController@listar');
        Route::get('cargo/listarConc', 'CargoController@listarCargos');
        Route::post('cargo/grade-salarial/listar', 'CargoController@getCargoByGrade');
        Route::post('cargo/update', 'CargoController@update');
        Route::post('cargo/insert', 'CargoController@insert');
        Route::post('cargo/delete', 'CargoController@delete');

        //Ccusto Lotação
        Route::get('ccustoLotacao/listar','CcustoLotacaoController@listar');
        Route::post('ccustoLotacao/update','CcustoLotacaoController@update');
        Route::post('ccustoLotacao/insert','CcustoLotacaoController@insert');
        Route::post('ccustoLotacao/delete','CcustoLotacaoController@delete');
        
        //Plano Lotac Unid
        Route::get('planoLotacUnid/listar','PlanoLotacUnidController@listar');
        Route::post('planoLotacUnid/update','PlanoLotacUnidController@update');
        Route::post('planoLotacUnid/insert','PlanoLotacUnidController@insert');
        Route::post('planoLotacUnid/delete','PlanoLotacUnidController@delete');

        //Atividades
        Route::get('atividades/listar','AtividadesController@listar');
        Route::post('atividades/update','AtividadesController@update');
        Route::post('atividades/insert','AtividadesController@insert');
        Route::post('atividades/delete','AtividadesController@delete');

        //Plano Lotacao Tipo
        Route::get('planoLotacaoTipo/listar','PlanoLotacaoTipoController@listar');
        Route::post('planoLotacaoTipo/update','PlanoLotacaoTipoController@update');
        Route::post('planoLotacaoTipo/insert','PlanoLotacaoTipoController@insert');
        Route::post('planoLotacaoTipo/delete','PlanoLotacaoTipoController@delete');

        //Plano Lotacao
        Route::get('planoLotacao/listar','PlanoLotacaoController@listar');
        Route::post('planoLotacao/update','PlanoLotacaoController@update');
        Route::post('planoLotacao/insert','PlanoLotacaoController@insert');
        Route::post('planoLotacao/delete','PlanoLotacaoController@delete');

        //Tp Funcionario

        Route::get('tpfuncionario/listar','TpFuncionarioController@listar');
        Route::post('tpfuncionario/update','TpFuncionarioController@update');
        Route::post('tpfuncionario/insert','TpFuncionarioController@insert');
        Route::post('tpfuncionario/delete','TpFuncionarioController@delete');
 
        /**Cargo Orc */
        Route::get('orcamento/{orc_id}/cargo/listar', 'OrcCargoSalController@listarCargo');
 
 
        Route::get('contaContabil/listar', 'ContaContabilController@listar');
        Route::post('contaContabil/update', 'ContaContabilController@update');
        Route::post('contaContabil/insert', 'ContaContabilController@insert');
        Route::post('contaContabil/delete', 'ContaContabilController@delete');

        /**Grade Salarial */
        Route::get('grade-salarial/listar', 'GradeSalarialController@listar');

        /**
         * Cronogramav
         */

        Route::post('orcamento/{orc_id}/cronograma/listar', 'OrcCronogramaController@list');
        Route::post('orcamento/{orc_id}/cronograma/insert', 'OrcCronogramaController@insertAll');
        Route::post('orcamento/{orc_id}/cronograma/update', 'OrcCronogramaController@updateAll');
        Route::post('orcamento/{orc_id}/cronograma/delete', 'OrcCronogramaController@deleteAll');
 

        
        Route::get('teste/cronograma/listar', 'OrcCronogramaController@verify');

         /**
          * Dissidio
          */

        Route::get('orcamento/{orc_id}/dissidio/listar', 'OrcDissidioController@listarAll');
        Route::post('orcamento/{orc_id}/dissidio/inserir', 'OrcDissidioController@inserirDissidio');
        Route::post('orcamento/{orc_id}/dissidio/editar', 'OrcDissidioController@editarDissidio');
        Route::post('orcamento/{orc_id}/dissidio/deletar', 'OrcDissidioController@deleteDissidio');
        
        /**
         * FORECAST
         */
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/forecast/finalizar','HeadcountController@finishedForecast');


        Route::get('orcamento/listar', 'OrcamentoController@listar');
        Route::get('orcamento/headcount/listar', 'OrcamentoController@listForHeadcount');
        Route::post('orcamento/update', 'OrcamentoController@update');
        Route::post('orcamento/insert', 'OrcamentoController@inserir');
        Route::post('orcamento/delete', 'OrcamentoController@delete');
        Route::post('orcamento/{orc_id}/liberar', 'OrcamentoController@releaseOrc');
        Route::post('orcamento/{orc_id}/aprovar', 'OrcamentoController@approveOrc');
        Route::post('orcamento/{orc_id}/reabrir', 'OrcamentoController@reopenOrc');
        Route::post('orcamento/{orc_id}/suspender', 'OrcamentoController@suspendedOrc');
        Route::post('orcamento/{orc_id}/aceitar', 'OrcamentoController@acceptOrc');
        Route::post('orcamento/{orc_id}/rejeitar', 'OrcamentoController@rejectOrc');
        Route::post('orcamento/{orc_id}/excluir', 'OrcamentoController@excluirOrc');

        Route::get('orcamento/getOrcamentoByID/{orc_id}', 'OrcamentoController@getOrcamentoByID');
        
        /**
         * ORCAMENTO EVENTOS 
         */
         
         
        Route::get('orcamento/{orc_id}/eventos/listar', 'OrcEventosController@listarAll')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/eventos/update', 'OrcEventosController@updateAll')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/eventos/insert', 'OrcEventosController@insertAll')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/eventos/delete', 'OrcEventosController@deleteAll')->where(['orc_id'=>'[0-9]+']);  
        
        /**
         *  EVENTOS LOTACAO
         */
        
        Route::get('orcamento/{orc_id}/lotacao/natureza/eventos/listar', 'OrcLotacaNaturezaEventoController@listarAll')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/natureza/eventos/update', 'OrcLotacaNaturezaEventoController@update')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/natureza/eventos/insert', 'OrcLotacaNaturezaEventoController@insert')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/natureza/eventos/delete', 'OrcLotacaNaturezaEventoController@delete')->where(['orc_id'=>'[0-9]+']);  
        
        /* OrcMovDespesas */
        Route::get('orcamento/{id}/movimentacao/despesa/listar', 'OrcMovDespesasController@listar')->where(['id'=>'[0-9]+']);
            
        /**
         * ORCAMENTO CARGO SALARIO
         */
 
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/diario-bordo/listar', 'OrcDiarioBordoController@listByRules')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/diario-bordo/insert', 'OrcDiarioBordoController@insert')->where(['orc_id'=>'[0-9]+']); 
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/diario-bordo/delete', 'OrcDiarioBordoController@delete')->where(['orc_id'=>'[0-9]+']);


        Route::get('cargo/orcamento/{orc_id}/listar', 'OrcCargoSalController@listarAll')->where(['orc_id'=>'[0-9]+']);
        Route::get('orcamento/{orc_id}/cargo/salario/listar', 'OrcCargoSalController@listarAll')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/cargo/salario/updateOrcCargo', 'OrcCargoSalController@updateOrcCargo')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/cargo/salario/insert', 'OrcCargoSalController@inserir')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/cargo/salario/deleteOrcCargo', 'OrcCargoSalController@deleteOrcCargo')->where(['orc_id'=>'[0-9]+']);
        // Route::get('orcamento/{orc_id}/cargo/salario/cargoExistenteOrc', 'OrcCargoSalController@cargoExistenteOrc')->where(['orc_id'=>'[0-9]+']);
                
        /*
         * ORCAMENTO CARGO SALARIO POR LOTACAO
         */        
         
        Route::get('orcamento/{orc_id}/lotacao/cargo/salario/listar', 'OrcLotacaoCargoSalController@listarAll')->where(['orc_id'=>'[0-9]+']); 
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/cargo/salario/listar', 'OrcLotacaoCargoSalController@listarAll')->where(['orc_id'=>'[0-9]+', 'lotacao_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/cargo/salario/update', 'OrcLotacaoCargoSalController@editar')->where(['orc_id'=>'[0-9]+', 'lotacao_id'=>'[0-9]+']); 
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/cargo/salario/insert', 'OrcLotacaoCargoSalController@inserirCargo')->where(['orc_id'=>'[0-9]+', 'lotacao_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/cargo/salario/delete', 'OrcLotacaoCargoSalController@deletar')->where(['orc_id'=>'[0-9]+', 'lotacao_id'=>'[0-9]+']);                
        
        Route::get('orcamento/{orc_id}/cargo/{cargo_id}/tempo/salario/listar', 'OrcCargoSalTempController@listar')->where(['orc_id'=>'[0-9]+', 'cargo_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/cargo/{cargo_id}/tempo/salario/update', 'OrcCargoSalTempController@update')->where(['orc_id'=>'[0-9]+', 'cargo_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/cargo/{cargo_id}/tempo/salario/insert', 'OrcCargoSalTempController@insert')->where(['orc_id'=>'[0-9]+', 'cargo_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/cargo/{cargo_id}/tempo/salario/delete', 'OrcCargoSalTempController@delete')->where(['orc_id'=>'[0-9]+', 'cargo_id'=>'[0-9]+']);                
        /**
         * Orçamento
         */
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/ferias/turma/listar/{tipo_table}', 'OrcFeriasController@listarByTurma')->where(['orc_id'=>'[0-9]+', 'lotacao_id'=>'[0-9]+']);
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/ferias/funcionario/listar/{tipo_table}', 'OrcFeriasController@listarByFuncionario')->where(['orc_id'=>'[0-9]+', 'cargo_d'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/ferias/{ferias_id}/update', 'OrcFeriasController@update')->where(['orc_id'=>'[0-9]+', 'ferias_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/ferias/{ferias_id}/insert', 'OrcFeriasController@insert')->where(['orc_id'=>'[0-9]+', 'ferias_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/ferias/{ferias_id}/delete', 'OrcFeriasController@delete')->where(['orc_id'=>'[0-9]+', 'ferias_id'=>'[0-9]+']);                

        /**
         * Orcamento Bonus
         */
        Route::get('orcamento/{orc_id}/lotacao/bonus/listar', 'OrcBonusController@listAll')->where(['orc_id'=>'[0-9]+', 'cargo_d'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/bonus/grade-salarial/listar', 'OrcBonusController@getCargoByGrade')->where(['orc_id'=>'[0-9]+', 'cargo_d'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/bonus/insert', 'OrcBonusController@insertBonus')->where(['orc_id'=>'[0-9]+', 'cargo_d'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/bonus/update', 'OrcBonusController@updateBonus')->where(['orc_id'=>'[0-9]+']);

        // Route::post('orcamento/{orc_id}/lotacao/bonus/grade-salarial/listar', 'OrcBonusController@getCargoByGrade')->where(['orc_id'=>'[0-9]+']);
        // Route::post('orcamento/{orc_id}/lotacao/bonus/insert', 'OrcBonusController@insert')->where(['orc_id'=>'[0-9]+']);
        // Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/bonus/update', 'OrcBonusController@updateBonus')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/bonus/delete', 'OrcBonusController@deleteBonus')->where(['orc_id'=>'[0-9]+']);

        /**
         * Orçamento Promoção
         */
        // Route::get('orcamento/{orc_id}/lotacao/promocao/listar', 'OrcPromocaoController@listar')->where(['orc_id'=>'[0-9]+']);
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/promocao/listar/{tipo_table}', 'OrcPromocaoController@listarByLotacao')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/promocao/insert', 'OrcPromocaoController@insert')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/promocao/update', 'OrcPromocaoController@update')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/promocao/delete', 'OrcPromocaoController@delete')->where(['orc_id'=>'[0-9]+']);

        /**
         * Orçamento Premissas
         */
        Route::post('orcamento/premissas/salvar', 'OrcPremissasController@salvar');
        Route::get('orcamento/premissas/getObservacoes/{orcamento_id}', 'OrcPremissasController@getObservacoes');


        /**
         * Orçamento Contratações
         */        
        Route::post('orcamento/contratacoes/insert', 'OrcContratacoesController@insert');
        Route::post('orcamento/contratacoes/delete', 'OrcContratacoesController@delete');

        /**
         * Orçamento Beneficios
         */        
        Route::post('orcamento/{orc_id}/beneficios/insert', 'OrcBeneficiosController@inserir');
        Route::get('orcamento/{orc_id}/beneficios/listar', 'OrcBeneficiosController@list');
        Route::get('orcamento/{orc_id}/beneficios/listEvent', 'OrcBeneficiosController@listEvent');
        Route::post('orcamento/{orc_id}/beneficios/delete', 'OrcBeneficiosController@deletar');
        Route::post('orcamento/{orc_id}/beneficios/update', 'OrcBeneficiosController@updateBeneficio');
        // Route::post('orcamento/contratacoes/delete', 'OrcContratacoesController@delete');
      Route::get('orcamento/cargoareasal/listar', 'CalcOrcamentoController@createcalc');
        Route::post('orcamento/{orc_id}/cloneOrcamento', 'CalcOrcamentoController@createcalc');
        /**
         * Orçamento lotação cargo Beneficios
         */        
        Route::post('orcamento/{orc_id}/lot-cargo-beneficios/insert', 'OrcLotCargoBeneficioController@inserirBeneficio');
        Route::get('orcamento/{orc_id}/lotacao/ccusto/lot-cargo-beneficios/listar', 'OrcLotCargoBeneficioController@list');
        Route::post('orcamento/{orc_id}/lot-cargo-beneficios/delete', 'OrcLotCargoBeneficioController@deletar');
        Route::post('orcamento/{orc_id}/lot-cargo-beneficios/update', 'OrcLotCargoBeneficioController@updateOrcLotCargoBenef');

        /**
         * Orçamento lotação funcionario Beneficios
         */        
        Route::post('orcamento/{orc_id}/lot-funcionario-beneficios/insert', 'OrcLotFuncionarioBeneficioController@inserirr');
        Route::get('orcamento/{orc_id}/lotacao/ccusto/lot-funcionario-beneficios/listar', 'OrcLotFuncionarioBeneficioController@list');
        Route::post('orcamento/{orc_id}/lot-funcionario-beneficios/delete', 'OrcLotFuncionarioBeneficioController@deletar');
        Route::post('orcamento/{orc_id}/lot-funcionario-beneficios/update', 'OrcLotFuncionarioBeneficioController@updateOrcLotFuncionarioBenef');
        /**
         * Orcamento salario funcionario
         */
        Route::get('orcamento/{orc_id}/sal-funcionario/listar', 'OrcSalarioFuncionarioController@listarAll');
        Route::post('orcamento/sal-funcionario/insert', 'OrcSalarioFuncionarioController@insert');
        Route::post('orcamento/sal-funcionario/update', 'OrcSalarioFuncionarioController@update');
        Route::post('orcamento/sal-funcionario/delete', 'OrcSalarioFuncionarioController@deleteAll');


        Route::get('lotacao/listar', 'LotacaoController@listar');
        Route::post('lotacao/update', 'LotacaoController@update');
        Route::post('lotacao/insert', 'LotacaoController@insert');
        Route::post('lotacao/delete', 'LotacaoController@delete'); 

        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/headcount-form/listar/{tipo_table}', 'HeadcountController@listarHeadcount');
        // Route::get('headcount/orcamento/{orcamento_id}/lotacao/{lotacao_id}/ccusto/{ccusto_id}/listar', 'HeadcountController@listar');
        Route::post('headcount/update/{tipo_table}', 'HeadcountController@updated');        
        Route::post('headcount/insert', 'HeadcountController@insert');
        Route::post('headcount/headcount-form/delete', 'HeadcountController@deleteHeadForm');

        // Route::get('headcount-demissoes/listarDemissoes', 'HeadcountController@listarDemissoes');
        Route::post('headcount-demissoes/insert', 'HeadcountDemissoesController@insert'); 
        Route::get('headcount-demissoes/orcamento/{orcamento_id}/lotacao/{lotacao_id}/ccusto/{ccusto_id}/listar/{tipo_table}', 'HeadcountController@listarDemissoes');   
        Route::post('orcamento/{orcamento_id}/lotacao/{lotacao_id}/headcount-demissoes/delete-all','HeadcountDemissoesController@deleteAll');
        Route::get('horas-extras/orcamento/{orc_id}/lotacao/{lotacao_id}/listar/{tipo_table}', 'HeadcountController@listarHeadcountHE');
        Route::post('headcount/updatehe', 'HeadcountController@updateHE'); Route::post('headcount/horas-extras/delete', 'HeadcountController@deleteHe'); 
        Route::post('headcount/horas-extras/delete', 'OrcHoraExtraController@deleteHe');  
        // Route::post('headcount/horas-extras/insert', 'HeadcountController@insertHe'); 

        // Route::get('headcount/listarContratacoes', 'HeadcountController@listarContratacoes');
        Route::get('headcount/orcamento/{orcamento_id}/lotacao/{lotacao_id}/ccusto/{ccusto_id}/listarContratacoes/{tipo_table}', 'HeadcountController@listarContratacoes');

        Route::get('headcount-lista/listar/{orcamento_id}', 'HeadcountListaController@listarOrc');

        
        // Route::get('headcount-lista/listar', 'HeadcountListaController@listar');
        
        Route::get('centro-custo/listar', 'CentroCustoController@listar');
        Route::post('centro-custo/update', 'CentroCustoController@update');
        Route::post('centro-custo/insert', 'CentroCustoController@insert');
        Route::post('centro-custo/delete', 'CentroCustoController@delete');

       /**
        * Hora Extra Do Orçamento
        */

        Route::post('orcamento/{orc_id}/hora-extra/insert','HoraExtraController@inserirHraExtra');

        Route::get('conta-contabil/listar', 'ContaContabilController@listar');
        Route::post('conta-contabil/update', 'ContaContabilController@update');
        Route::post('conta-contabil/insert', 'ContaContabilController@insert');
        Route::post('conta-contabil/delete', 'ContaContabilController@delete');
           
        Route::get('unidade-medida/listar', 'UnidadeMedidaController@listar');
        Route::post('unidade-medida/update', 'UnidadeMedidaController@update');
        Route::post('unidade-medida/insert', 'UnidadeMedidaController@insert');
        Route::post('unidade-medida/delete', 'UnidadeMedidaController@delete');
           
        Route::get('moeda/listar', 'MoedaController@listar');
        Route::post('moeda/update', 'MoedaController@update');
        Route::post('moeda/insert', 'MoedaController@insert');
        Route::post('moeda/delete', 'MoedaController@delete');

        Route::get('ajustes-salariais/listar', 'AjustesSalariaisController@listar');
        Route::get('ajustes-salariais/listarCargosLotacaoSeleted/{cod_lotacao}', 'AjustesSalariaisController@listarCargosLotacaoSeleted');
        Route::post('ajustes-salariais/update', 'AjustesSalariaisController@update');
        Route::post('ajustes-salariais/insert', 'AjustesSalariaisController@insert');
        Route::post('ajustes-salariais/delete', 'AjustesSalariaisController@delete');        
        
        //Eventos Tipo
        Route::get('eventosTipo/listar','EventosTipoController@listar');

        Route::get('eventos/listar', 'EventosController@listar');
        Route::get('eventos/{tipo_evento}/listar','EventosController@listarTipo');
        Route::post('eventos/update', 'EventosController@update'); 
        Route::post('eventos/insert', 'EventosController@insert');
        Route::post('eventos/delete', 'EventosController@delete'); 
        Route::get('orcamento/{orc_id}/eventos/colunaEventos', 'EventosController@colunaEventosHE');   

        Route::get('lotacao/ex', 'LotacaoController@ex');   

                   
        Route::get('lotacao-ccusto/listar', 'LotacaoCCustoController@listar');
        
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/hora-extra/resumo','HeadcountResumoController@resHorasExtras');
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/ferias/resumo','HeadcountResumoController@resFerias');
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/contratacoes/resumo','HeadcountResumoController@resContratacoes');
        Route::get('orcamento/{orc_id}/lotacao/{lotacao_id}/demissoes/resumo','HeadcountResumoController@resDemissoes');
   
        Route::get('orcamento/{orc_id}/lotacao-ccusto/listar', 'OrcLotacaoController@listarLot');
        
        
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/startHeadcount', 'OrcLotacaoController@startHeadcount');
        Route::post('orcamento/{orc_id}/lotacao/{lotacao_id}/sendRh', 'OrcLotacaoController@sendRh');


        //Natureza Ccusto
        Route::get('listarUpdateDel/{cod_custo}/listar','NaturezasCcustoController@listarUpdateDel');
        Route::get('naturezasCcusto/listar','NaturezasCcustoController@listar');
        Route::post('naturezasCcusto/update', 'NaturezasCcustoController@update');
        Route::post('naturezasCcusto/insert', 'NaturezasCcustoController@insert');
        Route::post('naturezasCcusto/delete', 'NaturezasCcustoController@delete');

    /*       
           
        /*
          orchoraextra
        */ 
        
        Route::get('hora-extra/orcamento/listar', 'OrcHoraExtraController@listar'); 
        /*
        insert
        */
         Route::post('headcount/horas-extras/insert','OrcHoraExtraController@insert');
         Route::post('orcamento/{orc_id}/lotacao/{orc_lotacao}/hora-extra/insert','OrcHoraExtraController@orcHeInsert');
                                                            /*classe                    metodo*/
        /*
        select headcount hora extra
        */
        Route::get('orcamento/{orc_id}/hora-extra/lista','OrcHoraExtraController@listar');

        
        
        
        

        //orc despesas
        Route::get('orcamento/{orc_id}/despesas/listar','OrcDespesasController@listarDesp')->where(['orc_id'=>'[0-9]+']);
        Route::post('orcamento/{orc_id}/despesas/insert','OrcDespesasController@insert');
        Route::post('orcamento/{orc_id}/despesas/update','OrcDespesasController@updateDespCalc');
        Route::post('orcamento/{orc_id}/despesas/delete','OrcDespesasController@delete');
    
        /**
         * CONSULTAS
         */
        Route::post('consultaGeral/buscar','ConsultaGeralController@buscar');

      /**
         * ORÇAMENTO HORA EXTRA COMPLEMENTOS
         */
        Route::get('orcamento/{orc_id}/hora-extra/listar', 'HoraExtraController@listarHe');

        Route::get('orcamento/hora-extra/lista-event-hora-extra', 'HoraExtraController@listaEventosHoraExtra');
        
        Route::post('orcamento/{orc_id}/hora-extra/deletar','HoraExtraController@deletar');

            /*       

        
        // });
 });



       });
});
     * 
     */
