<?php

namespace App\Support;
use Illuminate\Validation\Validator;
//use Illuminate\Support\Facades\Validator;
// extends Felixkiss\UniqueWithValidator\ValidatorExtension
//use \Felixkiss\UniqueWithValidator\ValidatorExtension;
use Carbon\Carbon;
use DB;
//use Session;
class CustomValidator  extends \Felixkiss\UniqueWithValidator\ValidatorExtension {
     public function __construct( $translator, $data, $rules, $messages = array(), $customAttributes = array() ) {
          parent::__construct( $translator, $data, $rules, $messages, $customAttributes );
          //$this->_set_custom_stuff();
     }

    /**
    * Produto fora delinha
    * Verifica se um produto esta fora de linha (Id paraceiro 400)
    */
    function validateForaLinha($attribute, $value, $parameters){
             $result=DB::table('stq')
                     ->where('refx','=',$value)
                     ->where('idparceiro','=','0000000400')
                     ->get();
             return (!$result);
    }
        /**
         * EAN13
         */
    function validateEan13($attribute, $value, $parameters){
        $this->adicionarMensagem('ean13', 'Código de barra invalido');
        return validateEan13($value);
    }
        /**
         * SIT - Situação tributaria
         * Verifica sae é uma site permitida
         */
    function validateIsSit($attribute, $value, $parameters){
          $result=array_pluck(DB::select(DB::raw("select FNC_HAS_SIT('".$value."') as sit FROM dual")),'sit');
           $this->adicionarMensagem('isSit', 'SIT não cadastrada');
          return(!empty($result[0]));
    }

    /**
    * CFOP X Operação
    * Verifica se um cfop esta relacionado ao umaoperação
    */
    function validateHasCfopXOperacao($attribute, $value, $parameters){
         $this->adicionarMensagem('hasCfopXOperacao', 'Já existe a relação entre o CFOP e o Imposto informado');
        $result=array_pluck(DB::select(DB::raw("select erp_imposto_1_id, cfop as sit FROM erp_cfop_x_operacao WHERE erp_imposto_1_id='".$parameters[1]."' AND cfop_id='".$parameters[0]."'")),'cfopxoper');
        return (!$result);
    }
   
        /**
         * Verifica se a combinação de Inicio+Fim+filial
         * existi na erp_corredor
         * $parameters[0]=fim
         * $parameters[1]=filial
         * $parameters[2]=id Opicional
         */
    function validateCorredorUnique($attribute, $value, $parameters){
            $retorno=false;
            $retorno_messagem='';

        if(is_string($value)===false && is_int($value)===false){
             $retorno_messagem='O inicio deve ser um número de 1 à 99 ou uma letra entre A e P';
             goto saida;
        }

        if(isset($parameters[0])===false)
        {
              $retorno_messagem='Informe o fim';
               goto saida;
        }

        if(isset($parameters[1])===false){
            $retorno_messagem='Informe a filial.';
            goto saida;
        }
          //:::Verifica se é um intervalo valido
          $inicio=strtoupper(trim($value));
          $fim=strtoupper(trim($parameters[0]));
          $filial=trim($parameters[1]);
          $id=isset($parameters[2])? intval($parameters[2]) : 0;
          //::: Define o qual é tipo de inicio e de fim
          //::: n=>numero ou l=>letra;
          $inicio_tipo=is_numeric($inicio)==false ?'l':'n';
          $fim_tipo=is_numeric($fim)==false? 'l':'n';
          $numeros_permitidos=range(1,99);
          $letras_permitidas=range('A','P');
          $todos=array_merge($numeros_permitidos, $letras_permitidas);

        //::: Procura a posição no array de valores permitidos de acordo com o tipo
        $pos_inicio=array_search($inicio, $inicio_tipo=='n'? $numeros_permitidos :$letras_permitidas );
        $pos_fim=array_search($fim,  $fim_tipo=='n'? $numeros_permitidos :$letras_permitidas);

        //::: Verifica se inicio e fim são valores permitidos de acordo com o tipo
        if($pos_inicio===false || $pos_fim===false){
            $retorno_messagem='O inicio e/ou fim não é um valor dentro dos intervalos [1-99], [A-P]';
            goto saida;
        }

        //::: Se inicio e fim são dos mesmo tipo(Exemplo numeros),
        //::: a posição de inicio não pode ser maior que a do fim
        if($inicio_tipo==$fim_tipo && $pos_fim<$pos_inicio){
            $retorno_messagem='Inicio não pode ser maior que o fim. Ex: 2-1, C-A';
            goto saida;
        }


        //   DB::enableQueryLog();
        $result=DB::table('erp_corredor')
                    ->select('id,inicio,fim')
                    ->where('id','!=',$id)
                    ->where('filial','=',$filial)
                    ->where('status','=','1')
                    ->orderBy('inicio','asc')
                    ->get();
        //Se ainda não tem corredores para filial retorna true
        if (!$result){
            $retorno=true;
            goto saida;
        }

        foreach($result as $k=>$row){
            //:::Pega a posição do inicio
            $interval_inicio=array_search($row->inicio, $todos);
            //::: Pega a posição do fim
            $interval_fim=array_search($row->fim, $todos);
            //::: Caso o inicio ou fim cadastrados não seja mais um intervalo valido
            //::: Ignora e torcer para não ser o intervalo enviado pelo usuario ou não ser uma alteração
            //::: Pq vai da erro de oracle unique violation
             if($interval_inicio===false && $interval_fim===false){
                continue;
             }
            //::: Extrai o intervalo
            $intervalo=array_slice($todos, $interval_inicio, ($interval_fim-$interval_inicio+1));
            //::: Verifica se o inicio ou o fim estão dentro do intervalo atual
            if(in_array($inicio, $intervalo) || in_array($fim, $intervalo)){
                //::: Verifica se o id é igual ao passado por parametro
                if($row->id!=$id){
                    //::: Se for retornar falso
                    $retorno_messagem='O ínicio e/ou fim está dentro de um intervalo('.$row->inicio.'-'.$row->fim.') já em uso nesta filial.';
                    goto saida;
                }
            }
        }
        //::: Retorna verdadeiro
        $retorno=true;

        saida:
             $this->adicionarMensagem('corredor_unique', $retorno_messagem);
             return $retorno;
    }
    function validateCnpj($attribute, $value, $parameters){
          $this->adicionarMensagem('cnpj', 'CNPJ invalido');
          return validar_cnpj($value);
    }
    function validateCpf($attribute, $value, $parameters){

     }
     /**
      *
      * @param type $attribute
      * @param type $value
      * @param type $parameters [0= nome tabela,
      * @return type
      */
    function validateErpUnique($attribute, $value, $parameters){
        $form_data=$this->getData();
        $tb='';
        $values=[];
        $id=0;
        foreach($parameters as $k=>$v){
            if($k==0){
                $tb=$v;
                continue;
            }
            if(isset($form_data[$v])===false){
                continue;
            }
            $valor=strlen($form_data[$v])==0? NULL: $form_data[$v];
            if($v=='id'){ //:::
                $id=intval($valor);
                continue;
            }
            $values=array_add($values, $v, $valor);
        }
        $tem_id=($id>0); //:::Se ID for maior que Zero tem ID
        $campos=implode(',', array_keys($values));
         // DB::enableQueryLog();
        $result=DB::table($tb)
                    ->select($campos.($tem_id===true? ',id':'')) //:::Adiciona o campo id
                    ->where($values)
                    ->get();
        //$sql=DB::getQueryLog();
        $this->adicionarMensagem('erp_unique', 'Já existe um combinação para '.$campos);
        $tem=count($result)==0;
        //:::Se tiver resultado e existe o campo id
        if($tem==false && $tem_id===true){
            //::: Se o id for o mesmo do banco retorna true
            $a=($id==$result[0]->id && $id>0);
            return $a;
        }
        return ($tem); //:::Se não tiver resultado retorna verdadeiro
    }

    

     private function adicionarMensagem($metodo_name, $mesagem){
          $fall_messages=$this->getFallbackMessages();
          $fall_messages[$metodo_name]=$mesagem;
          $this->setFallbackMessages($fall_messages);
     }

    

    
    
    /**
		 * Required if attribute
		 *
		 * Validate that a required attribute exists, only if another
		 * attribute satisfies the supplied conditions.
		 *
		 * i.e. 'What is your favourite PHP framework?' is only required if
		 * 'Do you use a framework?' is set to '1'.
		 */
		public function validateRequiredIfAttribute($attribute, $value, $parameters) {
		
			$required = false;
		
			switch($parameters[1]) {
			
				case '==':
					$required = $this->attributes[$parameters[0]] == $parameters[2];
					
				case '!=':
					$required = $this->attributes[$parameters[0]] != $parameters[2];
				
				case '===':
					$required = $this->attributes[$parameters[0]] === $parameters[2];
				
				case '!==':
					$required = $this->attributes[$parameters[0]] !== $parameters[2];
					
				case '<':
					$required = $this->attributes[$parameters[0]] < $parameters[2];
					
				case '<=':
					$required = $this->attributes[$parameters[0]] <= $parameters[2];
					
				case '>':
					$required = $this->attributes[$parameters[0]] > $parameters[2];
					
				case '>=':
					$required = $this->attributes[$parameters[0]] >= $parameters[2];
				
			}
			
			return $required ? $this->validate_required($attribute, $value) : true;
		}	
	
}
//'required_if_attribute:uses_framework,==,1'